# $Id: AliasMap.rb,v 1.3 2004/12/03 05:44:24 toki Exp $

require 'forwardable'

class AliasMap < WPM::PageContext
  extend Forwardable

  def init_context
    @control = page_option(:control)
    @alias_list = @control.aliases
    @alist = nil
    @index = nil
  end

  def_delegator :@alias_list, :modified_count
  def_delegator :@alias_list, :modified_count=

  def has_aliases?
    ! @alias_list.empty?
  end

  def alias_list
    list = Array.new
    @alias_list.each_with_index do |params, i|
      list.push({ :params => params, :pos => i })
    end

    list
  end

  attr_accessor :alias
  attr_accessor :index
  def_delegator '@alias[:params]', :alias_path
  def_delegator '@alias[:params]', :orig_path
  def_delegator '@alias[:params]', :virtual_host

  def up
    pos = @alias[:pos]
    if (1 <= pos && pos <= @alias_list.length - 1) then
      @alias_list.swap(pos, pos - 1)
      @control.set_aliases(@alias_list)
      @alias[:pos] = pos - 1
    end

    nil
  end

  def down
    pos = @alias[:pos]
    if (0 <= pos && pos <= @alias_list.length - 2) then
      @alias_list.swap(pos, pos + 1)
      @control.set_aliases(@alias_list)
      @alias[:pos] = pos + 1
    end

    nil
  end

  def up_disabled?
    @alias[:pos] <= 0
  end

  def down_disabled?
    @alias[:pos] >= @alias_list.length - 1
  end

  def edit
    driver.redirect('SetupAlias', { 'pos' => @alias[:pos].to_s })
    nil
  end

  def add
    driver.redirect('SetupAlias', { 'pos' => @alias_list.length.to_s })
    nil
  end

  def del
    pos = @alias[:pos]
    if (0 <= pos && pos <= @alias_list.length - 1) then
      @alias_list.delete_at(pos)
      @control.set_aliases(@alias_list)
    end

    nil
  end
end
