#!/usr/local/bin/ruby
# $Id: form.cgi,v 1.1 2004/04/27 13:44:46 toki Exp $

require 'erb'

include ERB::Util

def decode(enc_str)
  dec_str = enc_str.gsub(/\+/, ' ')
  dec_str.gsub!(/%([0-9A-Fa-f][0-9A-Fa-f])/) {|s| s[1, 2].hex.chr }
  dec_str
end

$messg = ''
if (ENV['REQUEST_METHOD'] == 'POST') then
  post_data = STDIN.read
  post_data.split(/&/).map{|s| s.split(/=/, 2) }.each do |name, value|
    name = decode(name)
    value = decode(value) if value
    if (name == 'message') then
      $messg << value
    end
  end
end

print "Content-Type: text/html\r\n"
print "\r\n"
erb = ERB.new(DATA.read)
print erb.result

__END__
<html>
<head><title>Form</title></head>
<body>
<h1>Form</h1>

<h2>Input</h2>
<form method="post">
<p>
<label for="message">Message:</label><br>
<textarea id="message" name="message" rows=25 cols=80
><%= html_escape($messg) %></textarea>
</p>
<p><input type="submit"></p>
</form>

<% unless ($messg.empty?) then %>
<h2>Output</h2>
<pre
><%= html_escape($messg) %></pre>
<% end %>

</body>
</html>
