// -*- C++ -*-
/*!
 * @file  TkEcTest.cpp * @brief T-Kernel rate Test component * $Date$ 
 *
 * $Id$ 
 */
#include "TkEcTest.h"

#include "btron/tkcall.h"

// Module specification
// <rtc-template block="module_spec">
static const char* tkectest_spec[] =
  {
    "implementation_id", "TkEcTest",
    "type_name",         "TkEcTest",
    "description",       "T-Kernel rate Test component",
    "version",           "1.0",
    "vendor",            "NEC Soft Ltd",
    "category",          "example",
    "activity_type",     "SPORADIC",
    "kind",              "DataFlowComponent",
    "max_instance",      "1",
    "language",          "C++",
    "lang_type",         "compile",
    // Configuration variables
    "conf.default.exetime", "125",
    "conf.default.maxcnt", "10",
    ""
  };
// </rtc-template>

TkEcTest::TkEcTest(RTC::Manager* manager)
    // <rtc-template block="initializer">
  : RTC::DataFlowComponentBase(manager)
    // </rtc-template>
{
}

TkEcTest::~TkEcTest()
{
}


RTC::ReturnCode_t TkEcTest::onInitialize()
{
  // Registration: InPort/OutPort/Service
  // <rtc-template block="registration">
  // Set InPort buffers

  // Set OutPort buffer

  // Set service provider to Ports

  // Set service consumers to Ports

  // Set CORBA Service Ports

  // </rtc-template>

  // <rtc-template block="bind_config">
  // Bind variables and configuration variable
  bindParameter("exetime", m_exetime, "125");
  bindParameter("maxcnt", m_maxcnt, "10");
  
  m_cnt = 0;
  m_diffTimeMax = 0;
  m_diffTimeMin = (longlong)0x0fffffff << 32 | (longlong)0xffffffff;
  
  // </rtc-template>
  return RTC::RTC_OK;
}


/*
RTC::ReturnCode_t TkEcTest::onFinalize()
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t TkEcTest::onStartup(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t TkEcTest::onShutdown(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

RTC::ReturnCode_t TkEcTest::onActivated(RTC::UniqueId ec_id)
{
  std::cout << "onActivated" << std::endl ;
  std::cout << "m_exetime:" << m_exetime << "msec" << std::endl ;
  std::cout << "m_maxcnt:" << m_maxcnt << std::endl ;
  
  /* w肳ꂽJEg1000傫ꍇ́A1000ɂB */
  if(m_maxcnt > 1000) m_maxcnt = 1000 ;
  
  /* btk_get_tim̓~bP */
  ERR ercd ;
  SYSTIM systim ;
  
  ercd = btk_get_tim(&systim);
  if(ercd < ER_OK)
  {
    std::cout << "ERROR btk_get_tim: " << ercd << std::endl ;
    return RTC::RTC_ERROR;
  }
  m_tvPrev = (longlong)systim.hi << 32 | (longlong)systim.lo;
  
  return RTC::RTC_OK;
}


RTC::ReturnCode_t TkEcTest::onDeactivated(RTC::UniqueId ec_id)
{
  std::cout << "onDeactivated" << std::endl ;
  return RTC::RTC_OK;
}


RTC::ReturnCode_t TkEcTest::onExecute(RTC::UniqueId ec_id)
{
    /* onExecutẽR[o(~b) */
    outExecTime();
    
    /* C̎s */
    dummyTaskExec();
    
    return RTC::RTC_OK;
}

/*
RTC::ReturnCode_t TkEcTest::onAborting(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t TkEcTest::onError(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t TkEcTest::onReset(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t TkEcTest::onStateUpdate(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t TkEcTest::onRateChanged(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/


void TkEcTest::dummyTaskExec()
{
    /* 1Execute125ms鏈{Ɖ */
    btk_slp_tsk(m_exetime);
}

longlong TkEcTest::getAvg(longlong data[], int num)
{
    int i;
    longlong sum = 0;
    
    for (i = 0; i < num; i++) {
        sum = ll_add(sum ,data[i]);
    }
    return sum / num;
}


void TkEcTest::outExecTime()
{
    longlong tv;

    /* btk_get_tim̓~bP */
    ERR ercd ;
    SYSTIM systim ;
    
    ercd = btk_get_tim(&systim);
    if(ercd < ER_OK)
    {
      std::cout << "ERROR btk_get_tim: " << ercd << std::endl ;
      return ;
    }
    tv = (longlong)systim.hi << 32 | (longlong)systim.lo;
    
    m_diffTime[m_cnt % m_maxcnt] = ll_sub(tv, m_tvPrev) ;
    m_diffTimeMax = m_diffTimeMax < m_diffTime[m_cnt % m_maxcnt] ? m_diffTime[m_cnt % m_maxcnt] : m_diffTimeMax ;
    m_diffTimeMin = m_diffTimeMin < m_diffTime[m_cnt % m_maxcnt] ? m_diffTimeMin : m_diffTime[m_cnt % m_maxcnt] ;
    m_tvPrev = tv;
    
    /* m_maxcnt񂲂ƂɕϒlƍőlAŏlo */
    if (m_cnt && (m_cnt + 1) % m_maxcnt == 0) {
        std::cout << "[time] " << getAvg(m_diffTime, m_maxcnt) << "msec";
        std::cout << " (min:" << m_diffTimeMin << ", max:" << m_diffTimeMax << ")" << std::endl;
    }
    
    m_cnt++;
}


extern "C"
{
 
  void TkEcTestInit(RTC::Manager* manager)
  {
    coil::Properties profile(tkectest_spec);
    manager->registerFactory(profile,
                             RTC::Create<TkEcTest>,
                             RTC::Delete<TkEcTest>);
  }
  
};



