// -*- C++ -*-
/*!
 * @file  SampleVelocity2DOut.cpp * @brief OutPort example component * $Date$ 
 *
 * $Id$ 
 */
#include "SampleVelocity2DOut.h"

// Module specification
// <rtc-template block="module_spec">
static const char* samplevelocity2dout_spec[] =
  {
    "implementation_id", "SampleVelocity2DOut",
    "type_name",         "SampleVelocity2DOut",
    "description",       "OutPort example component",
    "version",           "1.0",
    "vendor",            "NEC Soft Ltd",
    "category",          "example",
    "activity_type",     "SPORADIC",
    "kind",              "DataFlowComponent",
    "max_instance",      "1",
    "language",          "C++",
    "lang_type",         "compile",
    // Configuration variables
    ""
  };
// </rtc-template>

SampleVelocity2DOut::SampleVelocity2DOut(RTC::Manager* manager)
    // <rtc-template block="initializer">
  : RTC::DataFlowComponentBase(manager),
    m_Velocity2DOut("Velocity2D", m_Velocity2D)

    // </rtc-template>
{
}

SampleVelocity2DOut::~SampleVelocity2DOut()
{
}


RTC::ReturnCode_t SampleVelocity2DOut::onInitialize()
{
  // Registration: InPort/OutPort/Service
  // <rtc-template block="registration">
  // Set InPort buffers

  // Set OutPort buffer
  addOutPort("Velocity2D", m_Velocity2DOut);

  // Set service provider to Ports

  // Set service consumers to Ports

  // Set CORBA Service Ports

  // </rtc-template>

  // <rtc-template block="bind_config">
  // Bind variables and configuration variable

  // </rtc-template>
  return RTC::RTC_OK;
}


/*
RTC::ReturnCode_t SampleVelocity2DOut::onFinalize()
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t SampleVelocity2DOut::onStartup(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t SampleVelocity2DOut::onShutdown(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t SampleVelocity2DOut::onActivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t SampleVelocity2DOut::onDeactivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

RTC::ReturnCode_t SampleVelocity2DOut::onExecute(RTC::UniqueId ec_id)
{
  // Velocity2D
  m_Velocity2D.data.vx = 10.3;
  m_Velocity2D.data.vy = 20.4;
  m_Velocity2D.data.va = 30.2;
#ifndef __T_KERNEL__  
  m_Velocity2DOut.write();
#endif
  std::cout << "TimedVelocity2D write" << std::endl;
  std::cout << "VX:" << m_Velocity2D.data.vx << std::endl;
  std::cout << "VY:" << m_Velocity2D.data.vy << std::endl;
  std::cout << "VA:" << m_Velocity2D.data.va << std::endl;
  std::cout << std::endl;
#ifdef __T_KERNEL__  
  m_Velocity2DOut.write();
  sleep(5);
#endif
  
  return RTC::RTC_OK;
}

/*
RTC::ReturnCode_t SampleVelocity2DOut::onAborting(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t SampleVelocity2DOut::onError(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t SampleVelocity2DOut::onReset(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t SampleVelocity2DOut::onStateUpdate(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t SampleVelocity2DOut::onRateChanged(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/


extern "C"
{
 
  void SampleVelocity2DOutInit(RTC::Manager* manager)
  {
    coil::Properties profile(samplevelocity2dout_spec);
    manager->registerFactory(profile,
                             RTC::Create<SampleVelocity2DOut>,
                             RTC::Delete<SampleVelocity2DOut>);
  }
  
};



