// -*- C++ -*-
/*!
 * @file  SampleIn.cpp * @brief InPort example component * $Date$ 
 *
 * $Id$ 
 */
#include "SampleIn.h"

// Module specification
// <rtc-template block="module_spec">
static const char* samplein_spec[] =
  {
    "implementation_id", "SampleIn",
    "type_name",         "SampleIn",
    "description",       "InPort example component",
    "version",           "1.0",
    "vendor",            "NEC Soft Ltd",
    "category",          "example",
    "activity_type",     "SPORADIC",
    "kind",              "DataFlowComponent",
    "max_instance",      "1",
    "language",          "C++",
    "lang_type",         "compile",
    // Configuration variables
    ""
  };
// </rtc-template>

SampleIn::SampleIn(RTC::Manager* manager)
    // <rtc-template block="initializer">
  : RTC::DataFlowComponentBase(manager),
    m_OctetSeqIn("OctetSeq", m_OctetSeq),
    m_StringSeqIn("StringSeq", m_StringSeq),
    m_Point2DIn("Point2D", m_Point2D),
    m_Velocity2DIn("Velocity2D", m_Velocity2D),
    m_gpsdataIn("gpsdata", m_gpsdata),
    m_intensitydataIn("intensitydata", m_intensitydata)

    // </rtc-template>
{
}

SampleIn::~SampleIn()
{
}


RTC::ReturnCode_t SampleIn::onInitialize()
{
  // Registration: InPort/OutPort/Service
  // <rtc-template block="registration">
  // Set InPort buffers
  addInPort("OctetSeq", m_OctetSeqIn);
  addInPort("StringSeq", m_StringSeqIn);
  addInPort("Point2D", m_Point2DIn);
  addInPort("Velocity2D", m_Velocity2DIn);
  addInPort("gpsdata", m_gpsdataIn);
  addInPort("intensitydata", m_intensitydataIn);

  // Set OutPort buffer

  // Set service provider to Ports

  // Set service consumers to Ports

  // Set CORBA Service Ports

  // </rtc-template>

  // <rtc-template block="bind_config">
  // Bind variables and configuration variable

  // </rtc-template>
  return RTC::RTC_OK;
}


/*
RTC::ReturnCode_t SampleIn::onFinalize()
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t SampleIn::onStartup(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t SampleIn::onShutdown(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t SampleIn::onActivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t SampleIn::onDeactivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

RTC::ReturnCode_t SampleIn::onExecute(RTC::UniqueId ec_id)
{
  int i,j,maxsize;
  
  // TimedOctetSeq^
  if(m_OctetSeqIn.isNew())
  {
    m_OctetSeqIn.read();
    std::cout << "TimedOctetSeq read" << std::endl;
    maxsize = m_OctetSeq.data.length();
    for(i = 0; i < maxsize; i++)
    {
      std::cout << i << ":" << (int)m_OctetSeq.data[i] << std::endl;
    }
    std::cout << std::endl;
  }
  
  // TimedStringSeq^
  if(m_StringSeqIn.isNew())
  {
    m_StringSeqIn.read();
    std::cout << "TimedStringSeq read" << std::endl;
    maxsize = m_StringSeq.data.length();
    for(i = 0; i < maxsize; i++)
    {
      std::cout << i << ":" << m_StringSeq.data[i] << std::endl;
    }
    std::cout << std::endl;
  }
  
  // ȉAAhXWString^͑ΉĂȂ|LڂB
  // http://www.openrtp.jp/wiki/_hara/ja/RtORB/RtORB_CDR.html
  // TimedWStringSeq^
  
  // Point2D
  if(m_Point2DIn.isNew())
  {
    m_Point2DIn.read();
    std::cout << "TimedPoint2D read" << std::endl;
    std::cout << "X:" << m_Point2D.data.x << std::endl;
    std::cout << "Y:" << m_Point2D.data.y << std::endl;
    std::cout << std::endl;
  }
  
  // Velocity2D
  if(m_Velocity2DIn.isNew())
  {
    m_Velocity2DIn.read();
    std::cout << "TimedVelocity2D read" << std::endl;
    std::cout << "VX:" << m_Velocity2D.data.vx << std::endl;
    std::cout << "VY:" << m_Velocity2D.data.vy << std::endl;
    std::cout << "VA:" << m_Velocity2D.data.va << std::endl;
    std::cout << std::endl;
  }
  
  // GPSData
  if(m_gpsdataIn.isNew())
  {
    m_gpsdataIn.read();
    std::cout << "GPSData read" << std::endl;
    std::cout << "latitude:" << m_gpsdata.latitude << std::endl;
    std::cout << "longitude:" << m_gpsdata.longitude << std::endl;
    std::cout << "altitude:" << m_gpsdata.altitude << std::endl;
    std::cout << "horizontalError:" << m_gpsdata.horizontalError << std::endl;
    std::cout << "verticalError:" << m_gpsdata.verticalError << std::endl;
    std::cout << "heading:" << m_gpsdata.heading << std::endl;
    std::cout << "horizontalSpeed:" << m_gpsdata.horizontalSpeed << std::endl;
    std::cout << "verticalSpeed:" << m_gpsdata.verticalSpeed << std::endl;
    std::cout << "numSatellites:" << m_gpsdata.numSatellites << std::endl;
    std::cout << "fixType:" << m_gpsdata.fixType << std::endl;
    std::cout << std::endl;
  }
  
  // IntensityData
  if(m_intensitydataIn.isNew())
  {
    m_intensitydataIn.read();
    std::cout << "IntensityData read" << std::endl;
    std::cout << "IntensityList:" << std::endl;
    maxsize = m_intensitydata.ranges.length();
    for(i =0; i < maxsize; i++)
    {
      std::cout << i << ":" << m_intensitydata.ranges[i] << std::endl;
    }
    std::cout << "Point3D X:" << m_intensitydata.geometry.geometry.pose.position.x << std::endl;
    std::cout << "Point3D Y:" << m_intensitydata.geometry.geometry.pose.position.y << std::endl;
    std::cout << "Point3D Z:" << m_intensitydata.geometry.geometry.pose.position.z << std::endl;
    std::cout << "Orientation3D Roll:" << m_intensitydata.geometry.geometry.pose.orientation.r << std::endl;
    std::cout << "Orientation3D Pitch:" << m_intensitydata.geometry.geometry.pose.orientation.p << std::endl;
    std::cout << "Orientation3D Yaw:" << m_intensitydata.geometry.geometry.pose.orientation.y << std::endl;
    std::cout << "Size3D Length:" << m_intensitydata.geometry.geometry.size.l << std::endl;
    std::cout << "Size3D Width:" << m_intensitydata.geometry.geometry.size.w << std::endl;
    std::cout << "Size3D Height:" << m_intensitydata.geometry.geometry.size.h << std::endl;
    
    std::cout << "ElementGeometryList:" << std::endl;
    maxsize = m_intensitydata.geometry.elementGeometries.length();
    for(j=0; j < maxsize; j++)
    {
      std::cout << j << ":" << std::endl;
      std::cout << "  Position3D X:" << m_intensitydata.geometry.elementGeometries[j].pose.position.x << std::endl;
      std::cout << "  Position3D Y:" << m_intensitydata.geometry.elementGeometries[j].pose.position.y << std::endl;
      std::cout << "  Position3D Z:" << m_intensitydata.geometry.elementGeometries[j].pose.position.z << std::endl;
      std::cout << "  Orientation3D Roll:" << m_intensitydata.geometry.elementGeometries[j].pose.orientation.r << std::endl;
      std::cout << "  Orientation3D Pitch:" << m_intensitydata.geometry.elementGeometries[j].pose.orientation.p << std::endl;
      std::cout << "  Orientation3D Yaw:" << m_intensitydata.geometry.elementGeometries[j].pose.orientation.y << std::endl;
      std::cout << "  Size3D Length:" << m_intensitydata.geometry.elementGeometries[j].size.l << std::endl;
      std::cout << "  Size3D Width:" << m_intensitydata.geometry.elementGeometries[j].size.w << std::endl;
      std::cout << "  Size3D Height:" << m_intensitydata.geometry.elementGeometries[j].size.h << std::endl;
    }
    
    std::cout << "minAngle:" << m_intensitydata.config.minAngle << std::endl;
    std::cout << "maxAngle:" << m_intensitydata.config.maxAngle << std::endl;
    std::cout << "angularRes:" << m_intensitydata.config.angularRes << std::endl;
    std::cout << "minRange:" << m_intensitydata.config.minRange << std::endl;
    std::cout << "maxRange:" << m_intensitydata.config.maxRange << std::endl;
    std::cout << "rangeRes:" << m_intensitydata.config.rangeRes << std::endl;
    std::cout << "frequency:" << m_intensitydata.config.frequency << std::endl;
    
    std::cout << std::endl;
  }
  
  return RTC::RTC_OK;
}

/*
RTC::ReturnCode_t SampleIn::onAborting(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t SampleIn::onError(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t SampleIn::onReset(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t SampleIn::onStateUpdate(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t SampleIn::onRateChanged(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/


extern "C"
{
 
  void SampleInInit(RTC::Manager* manager)
  {
    coil::Properties profile(samplein_spec);
    manager->registerFactory(profile,
                             RTC::Create<SampleIn>,
                             RTC::Delete<SampleIn>);
  }
  
};



