// -*- C++ -*-
/*!
 * @file  MemleakBooleanIn.cpp * @brief InPort example component * $Date$ 
 *
 * $Id$ 
 */
#include "MemleakBooleanIn.h"

// Module specification
// <rtc-template block="module_spec">
static const char* memleakbooleanin_spec[] =
  {
    "implementation_id", "MemleakBooleanIn",
    "type_name",         "MemleakBooleanIn",
    "description",       "InPort example component",
    "version",           "1.0",
    "vendor",            "NEC Soft Ltd",
    "category",          "example",
    "activity_type",     "SPORADIC",
    "kind",              "DataFlowComponent",
    "max_instance",      "1",
    "language",          "C++",
    "lang_type",         "compile",
    // Configuration variables
    ""
  };
// </rtc-template>

MemleakBooleanIn::MemleakBooleanIn(RTC::Manager* manager)
    // <rtc-template block="initializer">
  : RTC::DataFlowComponentBase(manager),
    m_dataIn("data", m_data)

    // </rtc-template>
{
#ifdef __T_KERNEL__
  m_trueCnt = 0;
  m_falseCnt = 0;
#endif
}

MemleakBooleanIn::~MemleakBooleanIn()
{
}


RTC::ReturnCode_t MemleakBooleanIn::onInitialize()
{
  // Registration: InPort/OutPort/Service
  // <rtc-template block="registration">
  // Set InPort buffers
  addInPort("data", m_dataIn);

  // Set OutPort buffer

  // Set service provider to Ports

  // Set service consumers to Ports

  // Set CORBA Service Ports

  // </rtc-template>

  // <rtc-template block="bind_config">
  // Bind variables and configuration variable

  // </rtc-template>
  return RTC::RTC_OK;
}


/*
RTC::ReturnCode_t MemleakBooleanIn::onFinalize()
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakBooleanIn::onStartup(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakBooleanIn::onShutdown(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakBooleanIn::onActivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakBooleanIn::onDeactivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

RTC::ReturnCode_t MemleakBooleanIn::onExecute(RTC::UniqueId ec_id)
{
  if( m_dataIn.isNew() )
  {
    m_dataIn.read();
    if( m_data.data ==  true)
    {
#ifdef __T_KERNEL__
      m_trueCnt++;
      if(m_trueCnt > 100)
      {
        printf("TimedBoolean true\n");
        m_trueCnt = 0;
      }
#else
      printf("TimedBoolean true\n");
#endif
    }else{
#ifdef __T_KERNEL__
      m_falseCnt++;
      if(m_falseCnt > 100)
      {
        printf("TimedBoolean false\n");
        m_falseCnt = 0;
      }
#else
      printf("TimedBoolean false\n");
#endif
    }
  }
  
  return RTC::RTC_OK;
}

/*
RTC::ReturnCode_t MemleakBooleanIn::onAborting(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakBooleanIn::onError(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakBooleanIn::onReset(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakBooleanIn::onStateUpdate(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakBooleanIn::onRateChanged(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/


extern "C"
{
 
  void MemleakBooleanInInit(RTC::Manager* manager)
  {
    coil::Properties profile(memleakbooleanin_spec);
    manager->registerFactory(profile,
                             RTC::Create<MemleakBooleanIn>,
                             RTC::Delete<MemleakBooleanIn>);
  }
  
};



