// -*- C++ -*-
/*!
 * @file  BorderFloatOut.cpp * @brief OutPort example component * $Date$ 
 *
 * $Id$ 
 */
#include "BorderFloatOut.h"

// Module specification
// <rtc-template block="module_spec">
static const char* borderfloatout_spec[] =
  {
    "implementation_id", "BorderFloatOut",
    "type_name",         "BorderFloatOut",
    "description",       "OutPort example component",
    "version",           "1.0",
    "vendor",            "NEC Soft Ltd",
    "category",          "example",
    "activity_type",     "SPORADIC",
    "kind",              "DataFlowComponent",
    "max_instance",      "1",
    "language",          "C++",
    "lang_type",         "compile",
    // Configuration variables
    ""
  };
// </rtc-template>

BorderFloatOut::BorderFloatOut(RTC::Manager* manager)
    // <rtc-template block="initializer">
  : RTC::DataFlowComponentBase(manager),
    m_FloatDataOut("FloatData", m_FloatData)

    // </rtc-template>
{
}

BorderFloatOut::~BorderFloatOut()
{
}


RTC::ReturnCode_t BorderFloatOut::onInitialize()
{
  // Registration: InPort/OutPort/Service
  // <rtc-template block="registration">
  // Set InPort buffers

  // Set OutPort buffer
  addOutPort("FloatData", m_FloatDataOut);

  // Set service provider to Ports

  // Set service consumers to Ports

  // Set CORBA Service Ports

  // </rtc-template>

  // <rtc-template block="bind_config">
  // Bind variables and configuration variable

  // </rtc-template>
  return RTC::RTC_OK;
}


/*
RTC::ReturnCode_t BorderFloatOut::onFinalize()
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t BorderFloatOut::onStartup(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t BorderFloatOut::onShutdown(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t BorderFloatOut::onActivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t BorderFloatOut::onDeactivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

RTC::ReturnCode_t BorderFloatOut::onExecute(RTC::UniqueId ec_id)
{
  
#define FLOAT_MAX (3.40282347e+38F)
#define FLOAT_MIN (1.17549435e-38F)
  
  //TimedFloat
  m_FloatData.data = FLOAT_MIN;
#ifndef __T_KERNEL__
  m_FloatDataOut.write();
#endif
  
  printf("TimedFloat write\n");
  printf("TimedFloat %e\n",m_FloatData.data);
#ifdef __T_KERNEL__
  m_FloatDataOut.write();
  sleep(3);
#endif
  
  m_FloatData.data = -FLOAT_MIN;
#ifndef __T_KERNEL__
  m_FloatDataOut.write();
#endif
  
  printf("TimedFloat write\n");
  printf("TimedFloat %e\n",m_FloatData.data);
#ifdef __T_KERNEL__
  m_FloatDataOut.write();
  sleep(3);
#endif
  
  m_FloatData.data = FLOAT_MAX;
#ifndef __T_KERNEL__
  m_FloatDataOut.write();
#endif
  
  printf("TimedFloat write\n");
  printf("TimedFloat %e\n",m_FloatData.data);
#ifdef __T_KERNEL__
  m_FloatDataOut.write();
  sleep(3);
#endif
  
  m_FloatData.data = -FLOAT_MAX;
#ifndef __T_KERNEL__
  m_FloatDataOut.write();
#endif
  
  printf("TimedFloat write\n");
  printf("TimedFloat %e\n",m_FloatData.data);
#ifdef __T_KERNEL__
  m_FloatDataOut.write();
  sleep(3);
#endif
  
  return RTC::RTC_OK;
}

/*
RTC::ReturnCode_t BorderFloatOut::onAborting(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t BorderFloatOut::onError(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t BorderFloatOut::onReset(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t BorderFloatOut::onStateUpdate(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t BorderFloatOut::onRateChanged(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/


extern "C"
{
 
  void BorderFloatOutInit(RTC::Manager* manager)
  {
    coil::Properties profile(borderfloatout_spec);
    manager->registerFactory(profile,
                             RTC::Create<BorderFloatOut>,
                             RTC::Delete<BorderFloatOut>);
  }
  
};



