// -*- C++ -*-
/*!
 * @file  BorderDoubleOut.cpp * @brief OutPort example component * $Date$ 
 *
 * $Id$ 
 */
#include "BorderDoubleOut.h"

// Module specification
// <rtc-template block="module_spec">
static const char* borderdoubleout_spec[] =
  {
    "implementation_id", "BorderDoubleOut",
    "type_name",         "BorderDoubleOut",
    "description",       "OutPort example component",
    "version",           "1.0",
    "vendor",            "NEC Soft Ltd",
    "category",          "example",
    "activity_type",     "SPORADIC",
    "kind",              "DataFlowComponent",
    "max_instance",      "1",
    "language",          "C++",
    "lang_type",         "compile",
    // Configuration variables
    ""
  };
// </rtc-template>

BorderDoubleOut::BorderDoubleOut(RTC::Manager* manager)
    // <rtc-template block="initializer">
  : RTC::DataFlowComponentBase(manager),
    m_DoubleDataOut("DoubleData", m_DoubleData)

    // </rtc-template>
{
}

BorderDoubleOut::~BorderDoubleOut()
{
}


RTC::ReturnCode_t BorderDoubleOut::onInitialize()
{
  // Registration: InPort/OutPort/Service
  // <rtc-template block="registration">
  // Set InPort buffers

  // Set OutPort buffer
  addOutPort("DoubleData", m_DoubleDataOut);

  // Set service provider to Ports

  // Set service consumers to Ports

  // Set CORBA Service Ports

  // </rtc-template>

  // <rtc-template block="bind_config">
  // Bind variables and configuration variable

  // </rtc-template>
  return RTC::RTC_OK;
}


/*
RTC::ReturnCode_t BorderDoubleOut::onFinalize()
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t BorderDoubleOut::onStartup(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t BorderDoubleOut::onShutdown(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t BorderDoubleOut::onActivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t BorderDoubleOut::onDeactivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

RTC::ReturnCode_t BorderDoubleOut::onExecute(RTC::UniqueId ec_id)
{
  
#define DOUBLE_MAX (1.7976931348623157e+308)
#define DOUBLE_MIN (2.2250738585072014e-308)
  
  //TimedDouble
  m_DoubleData.data = DOUBLE_MIN;
#ifndef __T_KERNEL__
  m_DoubleDataOut.write();
#endif
  
  printf("TimedDouble write\n");
  printf("TimedDouble %e\n",m_DoubleData.data);
#ifdef __T_KERNEL__
  m_DoubleDataOut.write();
  sleep(3);
#endif
  
  m_DoubleData.data = -DOUBLE_MIN;
#ifndef __T_KERNEL__
  m_DoubleDataOut.write();
#endif
  
  printf("TimedDouble write\n");
  printf("TimedDouble %e\n",m_DoubleData.data);
#ifdef __T_KERNEL__
  m_DoubleDataOut.write();
  sleep(3);
#endif
  
  m_DoubleData.data = DOUBLE_MAX;
#ifndef __T_KERNEL__
  m_DoubleDataOut.write();
#endif
  
  printf("TimedDouble write\n");
  printf("TimedDouble %e\n",m_DoubleData.data);
#ifdef __T_KERNEL__
  m_DoubleDataOut.write();
  sleep(3);
#endif
  
  m_DoubleData.data = -DOUBLE_MAX;
#ifndef __T_KERNEL__
  m_DoubleDataOut.write();
#endif
  
  printf("TimedDouble write\n");
  printf("TimedDouble %e\n",m_DoubleData.data);
#ifdef __T_KERNEL__
  m_DoubleDataOut.write();
  sleep(3);
#endif
  
  return RTC::RTC_OK;
}

/*
RTC::ReturnCode_t BorderDoubleOut::onAborting(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t BorderDoubleOut::onError(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t BorderDoubleOut::onReset(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t BorderDoubleOut::onStateUpdate(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t BorderDoubleOut::onRateChanged(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/


extern "C"
{
 
  void BorderDoubleOutInit(RTC::Manager* manager)
  {
    coil::Properties profile(borderdoubleout_spec);
    manager->registerFactory(profile,
                             RTC::Create<BorderDoubleOut>,
                             RTC::Delete<BorderDoubleOut>);
  }
  
};



