# Locate Gearbox installation

# This module defines
# GEARBOX_HOME where to find include, lib, bin, etc.
# GEARBOX_FOUND, If set to 0, don't try to use Gearbox libraries, scripts, etc.
#
# We look for the cmake manifest file generated by Gearbox.

# start with 'not found'
set( GEARBOX_FOUND 0 CACHE BOOL "Do we have Gearbox?" )

find_path( GEARBOX_HOME gearbox_manifest.cmake
    # Test user-specified installation point (first look in the dir specified
    # with command line CMake variable, then with environment variable)
    ${GEARBOX_HOME}
    $ENV{GEARBOX_HOME}
    # Test standard installation points
    /usr/local
    /opt/gearbox
    C:/gearbox
)
# message( STATUS "DEBUG: manifest.cmake is apparently found in : ${GEARBOX_HOME}" )

# NOTE: if GEARBOX_HOME is set to *-NOTFOUND it will evaluate to FALSE
if( GEARBOX_HOME )
    set( GEARBOX_FOUND 1 CACHE BOOL "Do we have Gearbox?" FORCE )
endif( GEARBOX_HOME )
