// -*-C++-*-
/*!
 * @file  hokuyoaistSVC_impl.h
 * @brief Service implementation header of hokuyoaist.idl
 *
 */

#include "hokuyoaistSkel.h"


#ifndef HOKUYOAISTSVC_IMPL_H
#define HOKUYOAISTSVC_IMPL_H

#ifdef __T_KERNEL__
class rtc_hokuyoaist;
#endif
 
/*
 * Example class implementing IDL interface Hokuyo_Aist::HokuyoAist
 */
class Hokuyo_Aist_HokuyoAistSVC_impl
 : public virtual POA_Hokuyo_Aist::HokuyoAist,
   public virtual PortableServer::RefCountServantBase
{
 private:
   // Make sure all instances are built on the heap by making the
   // destructor non-public
   //virtual ~Hokuyo_Aist_HokuyoAistSVC_impl();

 public:
   // standard constructor
   Hokuyo_Aist_HokuyoAistSVC_impl();
   virtual ~Hokuyo_Aist_HokuyoAistSVC_impl();

#ifdef __T_KERNEL__
   void setup(rtc_hokuyoaist* owner) { owner_ = owner; }
#else
   void setup(RTC_HokuyoAist* owner) { owner_ = owner; }
#endif

   // attributes and operations
   void request_scan();

 private:
#ifdef __T_KERNEL__
     rtc_hokuyoaist* owner_;
#else
     RTC_HokuyoAist* owner_;
#endif
};



#endif // HOKUYOAISTSVC_IMPL_H


