// -*- C++ -*-
/*!
 * @file  Routing.h
 * @brief Network routing information handling functions
 * @date  $Date$
 * @author Noriaki Ando <n-ando@aist.go.jp>
 *
 * Copyright (C) 2010
 *     Noriaki Ando
 *     Task-intelligence Research Group,
 *     Intelligent Systems Research Institute,
 *     National Institute of
 *         Advanced Industrial Science and Technology (AIST), Japan
 *     All rights reserved.
 *
 * $Id$
 *
 */

#ifndef COIL_ROUTING_H
#define COIL_ROUTING_H

#include <string>
 
namespace coil
{
  /*!
   * @if jp
   * @brief 襢ɥ쥹Ѥ륨ɥݥȥɥ쥹
   * 
   * 襢ɥ쥹ͿȡκݤѤ륨ɥݥȤΥɥ쥹
   * ֤롣襢ɥ쥹 dest_addr ˤϡIPɥ쥹ޤFQDNۥ
   * ̾Ϳ뤳ȤǤ롣襢ɥ쥹
   * ãǽǤꡢѤ륨ɥݥȤ줿 true襢
   * 쥹ãǤʤ false ֤롣
   *
   * @param dest_addr 襢ɥ쥹ޤϥۥ̾
   * @param dest_if ̿Ԥݤ˻Ѥ륤󥿡ե̾
   * @return  true,  false
   * 
   * @else
   * @brief Getting network interface name from destination address
   *
   * This operation returns IP address of a endpoint to be used to
   * communicate with the given destination address. IP address and
   * FQDN hostname are available for the destination address
   * dest_addr. If a destination address are reachable and an endpoint
   * IP address is available, this operation returns true, and
   * otherwise false.
   *
   * @param dest_addr a destination address or host name
   * @param endpoint a IP address of the endpoint to be used to communicate
   *                 with the destination address
   * @return successful: true, failed: false
   *
   * @endif
   */
  bool dest_to_endpoint(std::string dest_addr, std::string& endpoint);

  /*!
   * @if jp
   * @brief 襢ɥ쥹Ѥͥåȥ󥿡ե̾
   * 
   * 襢ɥ쥹ͿȡκݤѤͥåȥ󥿡ե
   * ̾롼ƥ󥰥ơ֥뤫롣襢ɥ쥹 dest_addr 
   * ϡIPɥ쥹ޤFQDNۥ̾Ϳ뤳ȤǤ롣֤
   * dest_if ϥͥåȥ󥿡ե̾Ǥ롣襢ɥ쥹ã
   * ǽǤꡢѤͥåȥ󥿡ե̾줿
   * true襢ɥ쥹ãǤʤ false ֤롣
   *
   * @param dest_addr 襢ɥ쥹ޤϥۥ̾
   * @param dest_if ̿Ԥݤ˻Ѥ륤󥿡ե̾
   * @return  true,  false
   * 
   * @else
   * @brief Getting network interface name from destination address
   *
   * This operation returns network interface name to be used to
   * communicate with the given destination address. IP address and
   * FQDN hostname are available for the destination address
   * dest_addr. Returned dest_if means the network interface name. If
   * a destination address are reachable and network interface name is
   * available, this operation returns true, and otherwise false.
   *
   * @param dest_addr a destination address or host name
   * @param dest_if a network interface name to be used to communicate
   *                with the destination address
   * @return successful: true, failed: false
   *
   * @endif
   */
#ifndef __T_KERNEL__
  bool find_dest_ifname(std::string dest_addr, std::string& dest_if);
#endif

  /*!
   * @if jp
   * @brief ͥåȥ󥿡ե̾IPɥ쥹
   * 
   * ͥåȥ󥿡ե̾Ϳȡ󥿡ե˳
   * Ƥ줿IPɥ쥹֤IPɥ쥹ƤƤʤ
   * ϡfalse֤롣
   *
   * @param ifname ͥåȥ󥿡ե̾
   * @param ipaddr ͥåȥ󥿡ե˳Ƥ줿IPɥ쥹
   * @return  true,  false
   * 
   * @else
   * @brief Get IP address from a network interface name
   *
   * This operation returns IP address which is assigned with the
   * given network interface. If IP address could be obtained from the
   * network interface name, this operation returns true, otherwise
   * false.
   * 
   * @param ifname a network interface name
   * @param ipaddr IP address that is assigned to the network interface
   * @return successful: true, failed: false
   *
   * @endif
   */
#ifndef __T_KERNEL__
  bool ifname_to_ipaddr(std::string ifname, std::string& ipaddr);
#endif


  }; //namespace coil
#endif // COIL_ROUTING_H
