// -*- C++ -*-
/*!
 * @file  MyServiceProvider.cpp * @brief MyService Provider Sample component * $Date$ 
 *
 * $Id$ 
 */
#include "MyServiceProvider.h"

#ifdef DEBUG
//DEL #include <util/tmonitor.h>
#endif

// Module specification
// <rtc-template block="module_spec">
static const char* myserviceprovider_spec[] =
  {
    "implementation_id", "MyServiceProvider",
    "type_name",         "MyServiceProvider",
    "description",       "MyService Provider Sample component",
    "version",           "0.1",
    "vendor",            "AIST",
    "category",          "Generic",
#ifdef __T_KERNEL__
    "activity_type",     "DataFlowComponent",
#else
    "activity_type",     "SPORADIC",
    "kind",              "MyServiceProvider",
#endif
    "max_instance",      "10",
    "language",          "C++",
    "lang_type",         "compile",
    // Configuration variables
    ""
  };
// </rtc-template>

MyServiceProvider::MyServiceProvider(RTC::Manager* manager)
    // <rtc-template block="initializer">
  : RTC::DataFlowComponentBase(manager),
    m_MyServicePort("MyService")

    // </rtc-template>
{
}

MyServiceProvider::~MyServiceProvider()
{
}


RTC::ReturnCode_t MyServiceProvider::onInitialize()
{
  // Registration: InPort/OutPort/Service
  // <rtc-template block="registration">
  // Set InPort buffers

  // Set OutPort buffer

  // Set service provider to Ports
#ifdef DEBUG
//DEL tm_monitor();
#endif
//printf("%s:%d\n", __FILE__, __LINE__);
  m_MyServicePort.registerProvider("myservice0", "MyService", m_myservice0);
//printf("%s:%d\n", __FILE__, __LINE__);

  // Set service consumers to Ports

  // Set CORBA Service Ports
#ifdef __T_KERNEL__
//printf("%s:%d\n", __FILE__, __LINE__);
  registerPort(m_MyServicePort);
//printf("%s:%d\n", __FILE__, __LINE__);
#else
  addPort(m_MyServicePort);
#endif

  // </rtc-template>

  // <rtc-template block="bind_config">
  // Bind variables and configuration variable

  // </rtc-template>
  return RTC::RTC_OK;
}


/*
RTC::ReturnCode_t MyServiceProvider::onFinalize()
{
  return RTC::RTC_OK;
}
*/
/*
RTC::RetrnCode_t MyServiceProvider::onStartup(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MyServiceProvider::onShutdown(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MyServiceProvider::onActivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MyServiceProvider::onDeactivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MyServiceProvider::onExecute(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MyServiceProvider::onAborting(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MyServiceProvider::onError(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MyServiceProvider::onReset(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MyServiceProvider::onStateUpdate(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MyServiceProvider::onRateChanged(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/


extern "C"
{
 
  void MyServiceProviderInit(RTC::Manager* manager)
  {
    coil::Properties profile(myserviceprovider_spec);
    manager->registerFactory(profile,
                             RTC::Create<MyServiceProvider>,
                             RTC::Delete<MyServiceProvider>);
  }
  
};



