// -*- C++ -*-
/*!
 * @file  SampleRangeDataOut.cpp * @brief OutPort example component * $Date$ 
 *
 * $Id$ 
 */
#include "SampleRangeDataOut.h"

// Module specification
// <rtc-template block="module_spec">
static const char* samplerangedataout_spec[] =
  {
    "implementation_id", "SampleRangeDataOut",
    "type_name",         "SampleRangeDataOut",
    "description",       "OutPort example component",
    "version",           "1.0",
    "vendor",            "NEC Soft Ltd",
    "category",          "example",
    "activity_type",     "SPORADIC",
    "kind",              "DataFlowComponent",
    "max_instance",      "1",
    "language",          "C++",
    "lang_type",         "compile",
    // Configuration variables
    ""
  };
// </rtc-template>

SampleRangeDataOut::SampleRangeDataOut(RTC::Manager* manager)
    // <rtc-template block="initializer">
  : RTC::DataFlowComponentBase(manager),
    m_rangedataOut("rangedata", m_rangedata)

    // </rtc-template>
{
}

SampleRangeDataOut::~SampleRangeDataOut()
{
}


RTC::ReturnCode_t SampleRangeDataOut::onInitialize()
{
  // Registration: InPort/OutPort/Service
  // <rtc-template block="registration">
  // Set InPort buffers

  // Set OutPort buffer
  addOutPort("rangedata", m_rangedataOut);

  // Set service provider to Ports

  // Set service consumers to Ports

  // Set CORBA Service Ports

  // </rtc-template>

  // <rtc-template block="bind_config">
  // Bind variables and configuration variable

  // </rtc-template>
  return RTC::RTC_OK;
}


/*
RTC::ReturnCode_t SampleRangeDataOut::onFinalize()
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t SampleRangeDataOut::onStartup(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t SampleRangeDataOut::onShutdown(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t SampleRangeDataOut::onActivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t SampleRangeDataOut::onDeactivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

RTC::ReturnCode_t SampleRangeDataOut::onExecute(RTC::UniqueId ec_id)
{
  int i,maxsize;

  int rangelength = 700;
  m_rangedata.ranges.length(rangelength);
  for(i=0; i < rangelength; i++)
  {
    m_rangedata.ranges[i] = i;
  }
  
#if 0
  m_rangedata.ranges.length(2);
  m_rangedata.ranges[0] = 1;
  m_rangedata.ranges[1] = 2;
#endif

  m_rangedata.geometry.geometry.pose.position.x = 10;
  m_rangedata.geometry.geometry.pose.position.y = 20;
  m_rangedata.geometry.geometry.pose.position.z = 30;

  m_rangedata.geometry.geometry.pose.orientation.r = 40;
  m_rangedata.geometry.geometry.pose.orientation.p = 50;
  m_rangedata.geometry.geometry.pose.orientation.y = 60;

  m_rangedata.geometry.geometry.size.l = 70;
  m_rangedata.geometry.geometry.size.w = 80;
  m_rangedata.geometry.geometry.size.h = 90;

  m_rangedata.geometry.elementGeometries.length(2);
//  m_rangedata.geometry.elementGeometries.length(1);
  for(i = 0; i < 2; i++)
  {
    m_rangedata.geometry.elementGeometries[i].pose.position.x = ( (i+1) * 100 ) + 1;
    m_rangedata.geometry.elementGeometries[i].pose.position.y = ( (i+1) * 100 ) + 2;
    m_rangedata.geometry.elementGeometries[i].pose.position.z = ( (i+1) * 100 ) + 3;
   
    m_rangedata.geometry.elementGeometries[i].pose.orientation.r = ( (i+1) * 100 ) + 4;
    m_rangedata.geometry.elementGeometries[i].pose.orientation.p = ( (i+1) * 100 ) + 5;
    m_rangedata.geometry.elementGeometries[i].pose.orientation.y = ( (i+1) * 100 ) + 6;

    m_rangedata.geometry.elementGeometries[i].size.l = ( (i+1) * 100 ) + 7;
    m_rangedata.geometry.elementGeometries[i].size.w = ( (i+1) * 100 ) + 8;
    m_rangedata.geometry.elementGeometries[i].size.h = ( (i+1) * 100 ) + 9;
  }

  m_rangedata.config.minAngle = 1001;
  m_rangedata.config.maxAngle = 1002;
  m_rangedata.config.angularRes = 1003;
  m_rangedata.config.minRange = 1004;
  m_rangedata.config.maxRange = 1005;
  m_rangedata.config.rangeRes = 1006;
  m_rangedata.config.frequency = 1007;

  std::cout << "RangeData write" << std::endl;
  maxsize = m_rangedata.ranges.length();
  std::cout << "RangeList:" << std::endl;
  for(i = 0; i < maxsize; i++)
  {
    std::cout << i << ":" << m_rangedata.ranges[i] << std::endl;
  }
  std::cout << "RangerGeometry:" << std::endl;
  std::cout << "  Geometry3D:" << std::endl;
  std::cout << "    Pose3D:" << std::endl;
  std::cout << "      Point3D:" << std::endl;
  std::cout << "        x:" << m_rangedata.geometry.geometry.pose.position.x << std::endl;
  std::cout << "        y:" << m_rangedata.geometry.geometry.pose.position.y << std::endl;
  std::cout << "        z:" << m_rangedata.geometry.geometry.pose.position.z << std::endl;
  std::cout << "      Orientation3D:" << std::endl;
  std::cout << "        r:" << m_rangedata.geometry.geometry.pose.orientation.r << std::endl;
  std::cout << "        p:" << m_rangedata.geometry.geometry.pose.orientation.p << std::endl;
  std::cout << "        y:" << m_rangedata.geometry.geometry.pose.orientation.y << std::endl;
  std::cout << "    Size3D:" << std::endl;
  std::cout << "        l:" << m_rangedata.geometry.geometry.size.l << std::endl;
  std::cout << "        w:" << m_rangedata.geometry.geometry.size.w << std::endl;
  std::cout << "        h:" << m_rangedata.geometry.geometry.size.h << std::endl;
  maxsize = m_rangedata.geometry.elementGeometries.length();
  std::cout << "  ElementGeometryList:" << std::endl;
  for(i = 0; i < maxsize; i++)
  {
    std::cout << "    " << i << std::endl;
    std::cout << "      Pose3D:" << std::endl;
    std::cout << "        Point3D:" << std::endl;
    std::cout << "          x:" << m_rangedata.geometry.elementGeometries[i].pose.position.x << std::endl;
    std::cout << "          y:" << m_rangedata.geometry.elementGeometries[i].pose.position.y << std::endl;
    std::cout << "          z:" << m_rangedata.geometry.elementGeometries[i].pose.position.z << std::endl;
    std::cout << "        Orientation3D:" << std::endl;
    std::cout << "          r:" << m_rangedata.geometry.elementGeometries[i].pose.orientation.r << std::endl;
    std::cout << "          p:" << m_rangedata.geometry.elementGeometries[i].pose.orientation.p << std::endl;
    std::cout << "          y:" << m_rangedata.geometry.elementGeometries[i].pose.orientation.y << std::endl;
    std::cout << "      Size3D:" << std::endl;
    std::cout << "          l:" << m_rangedata.geometry.elementGeometries[i].size.l << std::endl;
    std::cout << "          w:" << m_rangedata.geometry.elementGeometries[i].size.w << std::endl;
    std::cout << "          h:" << m_rangedata.geometry.elementGeometries[i].size.h << std::endl;
  }
  std::cout << "RangerConfig:" << std::endl;
  std::cout << "  minAngle:" << m_rangedata.config.minAngle << std::endl;
  std::cout << "  maxAngle:" << m_rangedata.config.maxAngle << std::endl;
  std::cout << "  angularRes:" << m_rangedata.config.angularRes << std::endl;
  std::cout << "  minRange:" << m_rangedata.config.minRange << std::endl;
  std::cout << "  maxRange:" << m_rangedata.config.maxRange << std::endl;
  std::cout << "  rangeRes:" << m_rangedata.config.rangeRes << std::endl;
  std::cout << "  frequency:" << m_rangedata.config.frequency << std::endl;

  m_rangedataOut.write();
  sleep(5);
  
  return RTC::RTC_OK;
}

/*
RTC::ReturnCode_t SampleRangeDataOut::onAborting(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t SampleRangeDataOut::onError(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t SampleRangeDataOut::onReset(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t SampleRangeDataOut::onStateUpdate(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t SampleRangeDataOut::onRateChanged(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/


extern "C"
{
 
  void SampleRangeDataOutInit(RTC::Manager* manager)
  {
    coil::Properties profile(samplerangedataout_spec);
    manager->registerFactory(profile,
                             RTC::Create<SampleRangeDataOut>,
                             RTC::Delete<SampleRangeDataOut>);
  }
  
};



