// -*- C++ -*-
/*!
 * @file  MemleakUShortSeqIn.cpp * @brief InPort example component * $Date$ 
 *
 * $Id$ 
 */
#include "MemleakUShortSeqIn.h"

// Module specification
// <rtc-template block="module_spec">
static const char* memleakushortseqin_spec[] =
  {
    "implementation_id", "MemleakUShortSeqIn",
    "type_name",         "MemleakUShortSeqIn",
    "description",       "InPort example component",
    "version",           "1.0",
    "vendor",            "NEC Soft Ltd",
    "category",          "example",
    "activity_type",     "SPORADIC",
    "kind",              "DataFlowComponent",
    "max_instance",      "1",
    "language",          "C++",
    "lang_type",         "compile",
    // Configuration variables
    ""
  };
// </rtc-template>

MemleakUShortSeqIn::MemleakUShortSeqIn(RTC::Manager* manager)
    // <rtc-template block="initializer">
  : RTC::DataFlowComponentBase(manager),
    m_dataIn("data", m_data)

    // </rtc-template>
{
#ifdef __T_KERNEL__
  m_ushortCnt = 0;
#endif
}

MemleakUShortSeqIn::~MemleakUShortSeqIn()
{
}


RTC::ReturnCode_t MemleakUShortSeqIn::onInitialize()
{
  // Registration: InPort/OutPort/Service
  // <rtc-template block="registration">
  // Set InPort buffers
  addInPort("data", m_dataIn);

  // Set OutPort buffer

  // Set service provider to Ports

  // Set service consumers to Ports

  // Set CORBA Service Ports

  // </rtc-template>

  // <rtc-template block="bind_config">
  // Bind variables and configuration variable

  // </rtc-template>
  return RTC::RTC_OK;
}


/*
RTC::ReturnCode_t MemleakUShortSeqIn::onFinalize()
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakUShortSeqIn::onStartup(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakUShortSeqIn::onShutdown(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakUShortSeqIn::onActivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakUShortSeqIn::onDeactivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

RTC::ReturnCode_t MemleakUShortSeqIn::onExecute(RTC::UniqueId ec_id)
{
  int i, size;
  
  if( m_dataIn.isNew() )
  {
    m_dataIn.read();
#ifndef __T_KERNEL__
    printf("TimedUShortSeq\n");
#endif
    size = m_data.data.length();
    for(i = 0; i < size; i++)
    {
#ifdef __T_KERNEL__
      m_ushortCnt++;
      if(m_ushortCnt > 100)
      {
        printf("%d:%u\n", i, m_data.data[i]);
        m_ushortCnt = 0;
      }
#else
      printf("%d:%u\n", i, m_data.data[i]);
#endif
    }
  }
  
  return RTC::RTC_OK;
}

/*
RTC::ReturnCode_t MemleakUShortSeqIn::onAborting(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakUShortSeqIn::onError(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakUShortSeqIn::onReset(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakUShortSeqIn::onStateUpdate(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakUShortSeqIn::onRateChanged(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/


extern "C"
{
 
  void MemleakUShortSeqInInit(RTC::Manager* manager)
  {
    coil::Properties profile(memleakushortseqin_spec);
    manager->registerFactory(profile,
                             RTC::Create<MemleakUShortSeqIn>,
                             RTC::Delete<MemleakUShortSeqIn>);
  }
  
};



