// -*- C++ -*-
/*!
 * @file  MemleakShortIn.cpp * @brief InPort example component * $Date$ 
 *
 * $Id$ 
 */
#include "MemleakShortIn.h"

// Module specification
// <rtc-template block="module_spec">
static const char* memleakshortin_spec[] =
  {
    "implementation_id", "MemleakShortIn",
    "type_name",         "MemleakShortIn",
    "description",       "InPort example component",
    "version",           "1.0",
    "vendor",            "NEC Soft Ltd",
    "category",          "example",
    "activity_type",     "SPORADIC",
    "kind",              "DataFlowComponent",
    "max_instance",      "1",
    "language",          "C++",
    "lang_type",         "compile",
    // Configuration variables
    ""
  };
// </rtc-template>

MemleakShortIn::MemleakShortIn(RTC::Manager* manager)
    // <rtc-template block="initializer">
  : RTC::DataFlowComponentBase(manager),
    m_dataIn("data", m_data)

    // </rtc-template>
{
#ifdef __T_KERNEL__
  m_shortCnt = 0;
#endif
}

MemleakShortIn::~MemleakShortIn()
{
}


RTC::ReturnCode_t MemleakShortIn::onInitialize()
{
  // Registration: InPort/OutPort/Service
  // <rtc-template block="registration">
  // Set InPort buffers
  addInPort("data", m_dataIn);

  // Set OutPort buffer

  // Set service provider to Ports

  // Set service consumers to Ports

  // Set CORBA Service Ports

  // </rtc-template>

  // <rtc-template block="bind_config">
  // Bind variables and configuration variable

  // </rtc-template>
  return RTC::RTC_OK;
}


/*
RTC::ReturnCode_t MemleakShortIn::onFinalize()
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakShortIn::onStartup(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakShortIn::onShutdown(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakShortIn::onActivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakShortIn::onDeactivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

RTC::ReturnCode_t MemleakShortIn::onExecute(RTC::UniqueId ec_id)
{
  if( m_dataIn.isNew() )
  {
    m_dataIn.read();
#ifdef __T_KERNEL__
    m_shortCnt++;
    if(m_shortCnt > 100)
    {
      printf("TimedShort %d\n", m_data.data);
      m_shortCnt = 0;
    }
#else
    printf("TimedShort %d\n", m_data.data);
#endif
    
  }
  
  return RTC::RTC_OK;
}

/*
RTC::ReturnCode_t MemleakShortIn::onAborting(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakShortIn::onError(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakShortIn::onReset(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakShortIn::onStateUpdate(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakShortIn::onRateChanged(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/


extern "C"
{
 
  void MemleakShortInInit(RTC::Manager* manager)
  {
    coil::Properties profile(memleakshortin_spec);
    manager->registerFactory(profile,
                             RTC::Create<MemleakShortIn>,
                             RTC::Delete<MemleakShortIn>);
  }
  
};



