/**
 * @file nes_posix_stricmp.c
 * @brief This file is part of the posix library
 *
 * Copyright 2011 NEC Soft, Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h> /* Added by Wang yage @ NECSoft(JiNan) G5. 2007/05/15 */
#include <ctype.h>  /* Added by Wang yage @ NECSoft(JiNan) G5. 2007/05/15 */

#include "nes_posix_stricmp.h"

/**
 * nes_posix_stricmp - compare to strings case insensitively 
 * @param 	string
 * @retval int		0: equal >0: str1>str2 <0:str1<str2
 * 
 */
int nes_posix_stricmp(const char *str1,const char *str2)
{
	char *p1,*p2;
	int  i = 0, len = 0;
	if(str1 == NULL)
	{
		if(str2 != NULL)
			return -1;
		if(str2 == NULL)
			return 0;
	}
	p1 = (char*)str1;
	p2 = (char*)str2;
	len = (strlen(str1)<strlen(str2))? strlen(str1):strlen(str2);
	for(i = 0;i < len;i++)
	{
		if(toupper(*p1) == toupper(*p2))
		{
			p1++;
			p2++;
		}
		else
			return toupper(*p1)-toupper(*p2);
	}
	return strlen(str1)-strlen(str2);
}

