/**
 * @file nes_posix_time.h
 * @brief This file is part of the posix library
 *
 * Copyright 2011 NEC Soft, Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __NES_POSIX_TIME_H_
#define __NES_POSIX_TIME_H_

#include <typedef.h>

#ifdef NES_SE
#include <seio/sys/time.h>
#else
#include <unix/sys/time.h> /* For timeval struct */
#endif

#ifdef __cplusplus
extern "C" { 
#endif

#define CLOCK_REALTIME				0
#define CLOCK_MONOTONIC				1
#define CLOCK_PROCESS_CPUTIME_ID	2
#define CLOCK_THREAD_CPUTIME_ID		3
#define CLOCK_REALTIME_HR			4
#define CLOCK_MONOTONIC_HR			5

typedef int clockid_t;

/* get the current value tp for the specified clock(only support CLOCK_REALTIME)  */
IMPORT int nes_posix_clock_gettime(clockid_t clock_id, struct timespec *tp);

struct timezone {
	int	tz_minuteswest;	/* minutes W of Greenwich */
	int	tz_dsttime;		/* type of dst correction */
};

/* extern int settimeofday(const struct timeval *tv , const struct timezone *tz); */
IMPORT int nes_posix_gettimeofday(struct timeval *tv, struct timezone *tz);

#ifdef __cplusplus
} 
#endif

/* 
 * Zhanghuan @ NECsoft(JiNan). 2008/07/09 append 
 */
#ifdef __cplusplus
extern "C" { 
#endif

IMPORT int clock_gettime(clockid_t clock_id, struct timespec *tp);

IMPORT int gettimeofday(struct timeval *tv, struct timezone *tz);

#ifdef __cplusplus
}
#endif

#endif /*  _POSIX_TIME_H_ */
