/**
 * @file nes_posix_semaphore.h
 * @brief semaphore function interface define
 *
 * Copyright 2011 NEC Soft, Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __NES_POSIX_SEMAPHORE_H_
#define __NES_POSIX_SEMAPHORE_H_

#include <basic.h>
#include <string.h>

#ifdef NES_SE   /* Use Standard Extension */
#else           /* Use PMC Extension */
#include <stdio.h>
#include <btron/taskcomm.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

typedef struct {
	W semid;
#ifdef NES_SE   /* Use Standard Extension */
#else           /* Use PMC Extension */
	int value;
	W  lock;  /* __internal_lock_t */
#endif
} sem_t;

/* Value returned if `sem_open' failed.  */
#define SEM_FAILED	((sem_t *) 0)

/* Maximum value the semaphore can have.  */
#define SEM_VALUE_MAX 	(2147483647)

/* Initialize semaphore object SEM to VALUE.  If PSHARED then share it
with other processes.  */
IMPORT int nes_posix_sem_init(sem_t *sem, int pshared, unsigned int value);

/* Free resources associated with semaphore object SEM.  */
IMPORT int nes_posix_sem_destroy(sem_t *sem) ;

/* Wait for SEM being posted.  */
IMPORT int nes_posix_sem_wait(sem_t *sem);

/* Test whether SEM is posted.  */
IMPORT int nes_posix_sem_trywait(sem_t *sem) ;

/* Post SEM.  */
IMPORT int nes_posix_sem_post(sem_t *sem) ;

/* Get current value of SEM and store it in *SVAL.  */
IMPORT int nes_posix_sem_getvalue(sem_t *sem, int *sval);

#ifdef __cplusplus
}
#endif

/*
 * Maxiaochen @ NECsoft (JiNan). 2008/07/10 append
*/

#ifdef __cplusplus
extern "C" {
#endif

IMPORT int sem_init(sem_t* sem, int pshared, unsigned int value);
IMPORT int sem_destroy(sem_t* sem);
IMPORT int sem_wait(sem_t* sem);
IMPORT int sem_trywait(sem_t* sem);
IMPORT int sem_post(sem_t* sem);
IMPORT int sem_getvalue(sem_t* sem, int* sval);

#ifdef __cplusplus
}
#endif
#endif  /* semaphore.h */
