/**
 * @file nes_posix_proc.h
 * @brief This file is part of the posix library
 *
 * Copyright 2011 NEC Soft, Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __NES_POSIX_PROC_H
#define __NES_POSIX_PROC_H

#include <typedef.h>

//#include "tran_time.h"
#ifdef NES_SE
#include <seio/sys/types.h>
#include <seio/sys/time.h>
#else
#include <unix/sys/types.h>
#include <unix/sys/time.h>
#endif

#ifdef __cplusplus
extern "C" { 
#endif
	/* process number declaration */
#ifndef PROCESS_ID_NUMBER
#define PROCESS_ID_NUMBER 1024 
#endif

	/* define the parameter options of function waitpid()*/
	enum{
		WNOHANG,
		WUNTRACED = WNOHANG,
		WCONTINUED = WNOHANG,
	};

	/* terminate a process */
	IMPORT void nes_posix_exit(int status);

	/* cause the calling programme to be suspended from 
	   execution until either the number of realtime 
	   seconds specified by the argument seconds has 
	   elapsed or a signal is delivered to the calling
	   thread and its action is to invoke a signal-catching
	   function or to terminate the process. */
	IMPORT unsigned int nes_posix_sleep(unsigned int seconds);

	/* create a new process incording to the value of pri and path */
	IMPORT int nes_posix_t_cre_prc(W pri, const char* path);

	/*  This function obtain status information pertaining  
	    to one of the caller's child processes. Various     
	    options permit status information to be obtained for
	    child processes that have terminated or stopped.    
	    (wait any of child processes                       */
	IMPORT pid_t nes_posix_wait(int* status);

	/* This function obtain status information pertaining  
	   to one of the caller's child processes. Various     
	   options permit status information to be obtained for
	   child processes that have terminated or stopped.    
	   (only wait the child process,and don't wait for     
	   grandson and itself)                               */
	IMPORT pid_t nes_posix_waitpid(pid_t pid, int* status, int options);

	/*  This function delay the excution of the program    
	    from execution until specified time by req has     
	    elapsed or a signal is delivered to the calling    
	    process and its action is to invoke a signalcatchin
	    function or to terminate the process.if rem is not 
	    null,rem will save the least time.        */
	IMPORT int nes_posix_nanosleep(const struct timespec* req, struct timespec* rem);
#ifdef __cplusplus
} 
#endif
/*
 * Maxiaochen @ NECsoft (JiNan). 2008/07/10 append
*/

#ifdef __cplusplus
extern "C" { 
#endif

IMPORT void _exit(int status);

IMPORT unsigned int sleep(unsigned int seconds);

IMPORT int t_cre_prc(W pri, const char* path);

IMPORT pid_t wait(int* status);

IMPORT pid_t waitpid(pid_t pid, int* status, int options);

IMPORT int nanosleep(const struct timespec* req,struct timespec* rem);

#ifdef __cplusplus
} 
#endif
#endif
