<?php
	class RSSWriter {
		var $header;
		var $items;
		var $fh;
		
		function setFileHandler( &$fh ) {
			$this->fh = &$fh;
		}
		function setHeader( $arg ) {
			$this->header = $arg;
		}
		function showHeader() {
			@fwrite( $this->fh,
				'<rss version="2.0">' ."\n".
				'<channel>' ."\n".
				'<title>'.$this->header['title'].'</title>'."\n".
				'<link>'.$this->header['link'].'</link>'."\n".
				'<description>'.$this->header['description'].'</description>'."\n" );
		}
		function setItem( $arg ) {
			$this->items[] = $arg;
		}
		function showItems() {
			for ( $i=0; $i<count($this->items); $i++ ) {
				$date = gmdate( "D, d M Y H:i:s", $this->items[$i]['pubDate']  ) . " GMT";
				@fwrite( $this->fh,
					'<item>' ."\n".
					'<title>'.$this->items[$i]['title'].'</title>'."\n".
					'<link>'.$this->items[$i]['link'].'</link>'."\n".
					'<pubDate>'.$date.'</pubDate>'."\n".
					'<description>'.$this->items[$i]['description'].'</description>'."\n".
					'</item>' ."\n" );
			}
			unset( $this->items );
		}
		function showFooter() {
			@fwrite( $this->fh,
				"</channel>\n".
				"</rss>\n" );
		}
	}
?>