#!/usr/bin/env perl -w

#
# rss2imap_common - rss2imap common module.
#
# Copyright (C) 2004 Taku Kudo <taku@chasen.org>
#               2005 Yoshinari Takaoka <mumumu@mumumu.org>
#     All rights reserved.
#     This is free software with ABSOLUTELY NO WARRANTY.
#
# You can redistribute it and/or modify it under the terms of the
# GPL2, GNU General Public License version 2.
#
# $Id: Common.pm,v 1.3 2005/10/02 12:39:05 mumumu-org Exp $
#

use strict;
use RSS2IMAPLIB::Config;
use RSS2IMAPLIB::UserAgent;
use RSS2IMAPLIB::Unicode;
use Data::Dumper;

package RSS2IMAPLIB::Common;
{

    our $config = undef;

    sub new {
        my $pkg_name = shift;
        $config = RSS2IMAPLIB::Config->new()->get_global_configall();
        bless {}, $pkg_name;
    }

    sub getrss_and_response {

        my $this        = shift;
        my $uri         = shift;
        my $headers     = shift;
        my %header_hash = %{$headers};
        my $ua          = RSS2IMAPLIB::UserAgent->new();

        print Data::Dumper::Dumper( $config->{'proxy'} ) if($config->{'debug'});

        $ua->proxy(['http','ftp'], $config->{'proxy'}) if($config->{'proxy'});
        my $request = HTTP::Request->new('GET');
        $request->url($uri);

        #    set header if any.
        while (my ($key,$value) = each %header_hash) {
            $request->header( $key => $value );
        }

        #    finally send request.
        my $response = $ua->request($request);

        print "response code :" . $response->code . "\n" if ($config->{'debug'});

        if ($response->code eq '304') {
            print "skip $uri \n";
            return;
        }
        unless ($response->is_success) {
            warn "WARNING: connection error $uri\n";
            return;
        }

        my $content = $response->content;
        my $header = substr ($content, 0, 100);
        if ($header =~ /encoding="([^<>]*?)"/i) {
            $content = RSS2IMAPLIB::Unicode::to_utf8($content,$1);
        }
        $content =~ s/<\?xml.*?\?>/<\?xml version="1.0" encoding="utf-8"\?>/;

        return ($content, $response);
    }


    sub getUser {

        my $this    = shift;
        my $prompt  = shift;
        my $isproxy = shift;
        $prompt = "UserName :" unless(defined $prompt);

        if ($isproxy && defined $config->{'proxy-user'}) {
            return $config->{'proxy-user'};
        }

        #    prompt and get username
        print $prompt;
        my $user = <STDIN>;
        chomp($user);
        $user = undef unless length $user;

        if (!defined $config->{'proxy-user'} && $isproxy) {
            #   add username to @ARGV
            push @ARGV, "--proxy-user";
            push @ARGV, $user;
        }

        return $user;
    }


    sub getPass {

        my $this    = shift;
        my $prompt  = shift;
        my $isproxy = shift;
        $prompt = "Password: " unless(defined $prompt);

        if ($isproxy && defined $config->{'proxy-pass'}) {
            return $config->{'proxy-pass'};
        }

        print $prompt;
        my $password = undef;
        if( $^O =~ /Win32/ ) {
            eval 'use Term::Getch';
            if( $@ ) {
                warn "you dont install Term::Getch module."
                   . "use \"ppm install Term-Getch\"\n"
                   . "your password input will display in console!\n";
                $password = <STDIN>;
            } else {
                my @c = ();
                my $tmp;
                do {
                    $tmp = getch();
                    push @c, $tmp if $tmp and $tmp =~ /\w/;
                } while not $tmp or $tmp ne "\r";
                $password = join('' => @c);
            }
            print "\n";

        } else {
            system("stty -echo");
            $password = <STDIN>;
            system("stty echo");
            print "\n";  # because we disabled echo
        }
        chomp($password);
        $password = undef unless length $password;

        if (!defined $config->{'proxy-pass'} && $isproxy) {
            #   add password to @ARGV
            push @ARGV, "--proxy-pass";
            push @ARGV, $password;
        }

        return $password;
    }


    #    wrapper of proxy password getter
    sub getProxyPass_ifEnabled {

        my $this = shift;

        if ($config->{'proxy'} && $config->{'proxy-user'}) {
            $this->getPass( 'proxy password: ', 1 );
        }

    }

}

1;
