module GlossaryHelper

  def block_tag(tagname, options = {}, &blk)
    str = tag(tagname, options, true)
    str += yield
    str += "</#{tagname}>"
  end

  def term_link_new(name, proj)
    link_to(name + '?', :controller => 'glossary', :action => 'new', :id => proj,
            :new_term_name => name)
  end
  
  def term_link(term)
    str = link_to(term.name, :controller => 'glossary', :action => 'show', :id => term.project,
                  :term_id => term)
    unless (term.abbr_whole.empty?)
      str = block_tag(:abbr, :title=>term.abbr_whole) {str}
    end
    unless (term.rubi.empty?)
      str = block_tag(:ruby) {
        tstr = block_tag(:rb) {str}
        tstr += block_tag(:rp) {'('}
        tstr += block_tag(:rt) {h(term.rubi)}
        tstr += block_tag(:rp) {')'}
      }
    end
    str
  end

  
  def label_param(prmname)
    case prmname
    when 'id'
      '#'
    when 'project'
      I18n.t(:label_project)
    when 'category'
      I18n.t(:field_category)
    when 'datetime'
      I18n.t(:field_updated_on)
    else
      I18n.t("label.#{prmname}")
    end
  end

  
  def param_visible?(prmname)
    !Setting.plugin_redmine_glossary["hide_item_#{prmname}"]
  end

  def collect_visible_params(prmary)
    ary = []
    prmary {|prm|
      ary << prm	if param_visible?(prm)
    }
  end
  
  def default_show_params; Term.default_show_params; end
  def default_searched_params; Term.default_searched_params; end
  def default_sort_params; Term.default_sort_params; end


  def params_select(form, name, prms)
    options = prms.collect{|prm| [label_param(prm), prm]}
    form.select(name, options, :include_blank=>true)
  end

  def params_select_tag(name, prms, defaultprm)
    options = [""]
    options += prms.collect{|prm| [label_param(prm), prm]}
    select_tag(name, options_from_collection_for_select(options), defaultprm)
  end
  

  # extract tokens from the question
  # eg. hello "bye bye" => ["hello", "bye bye"]
  def tokenize_by_space(str)
    str.scan(%r{((\s|^)"[\s\w]+"(\s|$)|\S+)}).collect {|m|
      m.first.gsub(%r{(^\s*"\s*|\s*"\s*$)}, '')
    }
  end


  
  def updated_by(updated, author)
    time_tag = content_tag('acronym', distance_of_time_in_words(Time.now, updated), :title => format_time(updated))
    author_tag = (author.is_a?(User) && !author.is_a?(AnonymousUser)) ? link_to(h(author), :controller => 'account', :action => 'show', :id => author) : h(author || 'Anonymous')
    l(:label_updated_time_by, :author => author_tag, :age => time_tag)
  end


  def glossary_to_csv(terms)
    ic = Iconv.new(l(:general_csv_encoding), 'UTF-8')    
    decimal_separator = l(:general_csv_decimal_separator)
    export = FCSV.generate(:col_sep => l(:general_csv_separator)) do |csv|
      # csv header fields
      headers = [ "#",
                 l(:field_project),
                 t('label.name'),
                 t('label.category'),
                 t('label.datatype'),
                 t('label.codename'),
                 t('field_author'),
                 t('label_updater'),
                 t('field_created_on'),
                 t('field_updated_on'),
                 t('label.name_en')
      ]

      # Description in the last column
      headers << l(:field_description)
      csv << headers.collect {|c| begin; ic.iconv(c.to_s); rescue; c.to_s; end }

      # csv lines
      terms.each do |term|
        fields = [term.id,
                  term.project.name,
                  term.category, 
                  term.datatype,
                  term.codename,
                  term.author,
                  term.updater,
                  format_time(term.created_on),
                  format_time(term.updated_on),
                  term.name_en            
        ]
        fields << term.description
        csv << fields.collect {|c| begin; ic.iconv(c.to_s); rescue; c.to_s; end }
      end
    end
    export
  end

end
