/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import java.io.PrintStream;
import jp.robotbrain.signal.IndexObject;
import jp.robotbrain.signal.Tag;

public class Dmi
extends IndexObject {
    private static final long serialVersionUID = 1L;
    private final double m_plusDi;
    private final double m_minusDi;

    public Dmi(Tag p_tag, double p_plusDi, double p_minusDi) {
        super(p_tag);
        this.m_plusDi = p_plusDi;
        this.m_minusDi = p_minusDi;
    }

    public double getDx() {
        if (this.m_plusDi + this.m_minusDi == 0.0) {
            return 0.0;
        }
        double returnValue = Math.abs(this.m_plusDi - this.m_minusDi) / (this.m_plusDi + this.m_minusDi) * 100.0;
        return returnValue;
    }

    public double getPlusDi() {
        return this.m_plusDi;
    }

    public double getMinusDi() {
        return this.m_minusDi;
    }

    @Override
    public void printHeader(PrintStream p_out) {
        p_out.println("Tag,'+DI','-DI',DX");
    }

    @Override
    public void print(PrintStream p_out) {
        p_out.println("'" + this.getTag().getString() + "'," + this.getPlusDi() + "," + this.getMinusDi() + "," + this.getDx());
    }

    @Override
    public final String toXml() {
        StringBuilder returnValue = new StringBuilder();
        returnValue.append("<dmi tag=\"");
        returnValue.append(this.getTag().getString());
        returnValue.append("\">");
        returnValue.append("<plusdi>");
        returnValue.append(this.getPlusDi());
        returnValue.append("</plusdi>");
        returnValue.append("<minusdi>");
        returnValue.append(this.getMinusDi());
        returnValue.append("</minusdi>");
        returnValue.append("<dx>");
        returnValue.append(this.getDx());
        returnValue.append("</dx>");
        returnValue.append("</dmi>");
        return returnValue.toString();
    }
}

