/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import jp.robotbrain.framework.Gene;
import jp.robotbrain.framework.GeneDefaultLabelList;
import jp.robotbrain.framework.GeneList;
import jp.robotbrain.framework.GeneListException;
import jp.robotbrain.signal.CandleStick;
import jp.robotbrain.signal.CandleStickListStream;
import jp.robotbrain.signal.CandleStickTimeTable;
import jp.robotbrain.signal.IndexLine;
import jp.robotbrain.signal.IndexObjectList;
import jp.robotbrain.signal.IndexPoint;
import jp.robotbrain.signal.IndexStreamException;
import jp.robotbrain.signal.InputComponentList;
import jp.robotbrain.signal.SimpleLine;
import jp.robotbrain.signal.Tag;
import jp.robotbrain.signal.TypeIndexStream;

@TypeIndexStream(value="CandleStickList")
@InputComponentList(values={"@IndexLine"})
@GeneDefaultLabelList(values={"minute"})
public class CandleStickFactory
extends CandleStickListStream {
    private static final long serialVersionUID = 1L;
    private final CandleStickTimeTable m_timeTable;
    private int m_prevArea = -1;
    private SimpleLine m_accumulateLine = new SimpleLine();

    public CandleStickFactory(String p_label, GeneList p_geneList, String p_minuteLabel) throws GeneListException, IndexStreamException {
        super(p_label);
        Gene ccountRangeGene = p_geneList.getGene(p_minuteLabel);
        this.m_timeTable = new CandleStickTimeTable(ccountRangeGene.getIntValue());
    }

    @Override
    public void notifyIndex(IndexObjectList<?> p_indexObjectList) throws IndexStreamException {
        if (p_indexObjectList == null) {
            throw new IndexStreamException("Null Error");
        }
        if (!(p_indexObjectList instanceof IndexLine)) {
            throw new IndexStreamException("Instance Error");
        }
        if (p_indexObjectList.size() <= 0) {
            return;
        }
        IndexPoint last = (IndexPoint)p_indexObjectList.getLast();
        int area = this.m_timeTable.lookup(last.getTag().getTime());
        if (this.m_prevArea == -1) {
            this.m_prevArea = area;
        }
        if (this.m_prevArea != area) {
            CandleStick c = this.createCandleStick(last.getTag(), this.m_accumulateLine);
            this.getValues().add(c);
            this.notifyIndexNext(this.getValues());
            this.m_accumulateLine = new SimpleLine();
            this.m_accumulateLine.addPoint(last);
            this.m_prevArea = area;
        } else {
            this.m_accumulateLine.addPoint(last);
        }
    }

    private CandleStick createCandleStick(Tag p_tag, IndexLine p_src) {
        if (p_src == null) {
            return null;
        }
        if (p_src.size() <= 0) {
            return null;
        }
        double open = ((IndexPoint)p_src.get(0)).getValue();
        double close = ((IndexPoint)p_src.getLast()).getValue();
        double high = p_src.getMax().getValue();
        double low = p_src.getMin().getValue();
        CandleStick c = new CandleStick(p_tag, open, high, low, close);
        return c;
    }
}

