/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import jp.robotbrain.framework.Gene;
import jp.robotbrain.framework.GeneDefaultLabelList;
import jp.robotbrain.framework.GeneList;
import jp.robotbrain.framework.GeneListException;
import jp.robotbrain.signal.CandleStick;
import jp.robotbrain.signal.CandleStickAvgLine;
import jp.robotbrain.signal.CandleStickList;
import jp.robotbrain.signal.IndexObjectList;
import jp.robotbrain.signal.IndexStream;
import jp.robotbrain.signal.IndexStreamException;
import jp.robotbrain.signal.InputComponentList;
import jp.robotbrain.signal.TypeIndexStream;

@TypeIndexStream(value="CandleStickAvgLine")
@InputComponentList(values={"@CandleStickList"})
@GeneDefaultLabelList(values={"closeRatio"})
public class CandleStickAvgLineStream
extends IndexStream {
    private static final long serialVersionUID = 1L;
    private final CandleStickAvgLine m_candleStickAvgLine;

    public CandleStickAvgLineStream(String p_label, GeneList p_geneList, String p_closeRatioLabel) throws GeneListException {
        super(p_label);
        Gene closeRatioGene = p_geneList.getGene(p_closeRatioLabel);
        int closeRatio = closeRatioGene.getIntValue();
        this.m_candleStickAvgLine = new CandleStickAvgLine(closeRatio);
    }

    public void enter(CandleStickList p_src) throws IndexStreamException {
        this.notifyIndex(p_src);
    }

    @Override
    public void notifyIndex(IndexObjectList<?> p_indexObjectList) throws IndexStreamException {
        if (p_indexObjectList == null) {
            throw new IndexStreamException("Null Error");
        }
        if (!(p_indexObjectList instanceof CandleStickList)) {
            throw new IndexStreamException("Instance Error");
        }
        if (p_indexObjectList.size() <= 0) {
            return;
        }
        int prevSize = this.m_candleStickAvgLine.size();
        this.m_candleStickAvgLine.addPoint((CandleStick)p_indexObjectList.getLast());
        if (this.m_candleStickAvgLine.size() > prevSize) {
            this.notifyIndexNext(this.m_candleStickAvgLine);
        }
    }

    public CandleStickAvgLine getValues() {
        return this.m_candleStickAvgLine;
    }
}

