/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;

public class CandleStickTimeTable {
    private HashMap<String, Integer> m_timetable;

    public CandleStickTimeTable(int p_minute) {
        try {
            InputStream istream = this.getClass().getResourceAsStream("cstable/" + p_minute + ".txt");
            if (istream == null) {
                throw new RuntimeException("Candlestick Timetable Not Found minute=" + p_minute);
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(istream));
            this.m_timetable = new HashMap();
            while (br.ready()) {
                String line = br.readLine();
                String[] cols = line.split(",");
                if (cols.length != 2) {
                    throw new RuntimeException("col count error col=" + cols.length);
                }
                this.m_timetable.put(cols[0], Integer.parseInt(cols[1]));
            }
            br.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
    }

    public synchronized int lookup(String p_time) {
        return this.m_timetable.get(p_time);
    }
}

