/*
 * Copyright 2004-2006 Robbie.JP
 */
package robbie.util;

import java.lang.reflect.Constructor;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;



/**
 * w肵NX̃CX^X𐶐t@NgNXB<p>
 * Ver1.0.2ȍ~́ARXgN^ɂΉ܂B
 */
public class InstanceFactory {

    private static final Log LOG = LogFactory.getLog(InstanceFactory.class);
    
    /**
     * w肵NX̃CX^X𐶐B<p>
     * @param className 쐬CX^X̃NX
     * @return 쐬CX^X
     */
    public static Object createInstance(String className) {

        try {
            return Class.forName(className).newInstance();
        } catch(ClassNotFoundException ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("NXftHg̃NX[_ł͌܂. class=" + className + "] in default class loader.");
                LOG.debug("Thread.currentThread().getContextClassLoader()gpăNX܂.");
            }
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            return createInstance(className, loader);
        } catch(Exception ex) {
            LOG.error("NX܂ł. name=" + className);
            throw new InstanceCreateFailureException("InstanceFactory::createInstance() failed", ex);
        }
    }

    /**
     * w肵NX̃CX^Xw肵NX[_ŐB<p>
     * @param className 쐬CX^X̃NX
     * @param loader NX[_
     * @return 쐬CX^X
     */
    public static Object createInstance(String className, ClassLoader loader) {
 
        try {
            if (loader == null) {
                return createInstance(className);
            }
            return Class.forName(className, true, loader).newInstance();
        } catch (Exception ex) {
            if(ex instanceof InstanceCreateFailureException) {
                throw (InstanceCreateFailureException)ex;
            }
            LOG.error("NX܂ł. name=" + className);
            throw new InstanceCreateFailureException("InstanceFactory::createInstance() failed", ex);
        }
    }
    
    /**
     * w肵NX̃CX^X𐶐B<p>
     * @param className 쐬CX^X̃NX
     * @param args RXgN^̈
     * @return 쐬CX^X
     * @since 1.0.2
     */
    public static Object createInstance(String className, Object[] args) {
        
        try {
            Class objClass = Class.forName(className);
            return createInstance(objClass, args);
        } catch(ClassNotFoundException ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("NXftHg̃NX[_ł͌܂. class=" + className + "] in default class loader.");
                LOG.debug("Thread.currentThread().getContextClassLoader()gpăNX܂.");
            }
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            return createInstance(className, args, loader);
        } catch(Exception ex) {
            if (ex instanceof InstanceCreateFailureException) {
                throw (InstanceCreateFailureException)ex;
            }
            LOG.error("NX܂ł. name=" + className);
            throw new InstanceCreateFailureException("InstanceFactory::createInstance() failed", ex);
        }
    }
    
    /**
     * w肵NX̃CX^Xw肵NX[_ŐB<p>
     * @param className 쐬CX^X̃NX
     * @param args RXgN^̈
     * @param loader NX[_
     * @return 쐬CX^X
     * @since 1.0.2
     */
    public static Object createInstance(String className, Object[] args, ClassLoader loader) {
        
        try {
            if (loader == null) {
                return createInstance(className, args);
            }
            Class objClass = Class.forName(className, true, loader);
            return createInstance(objClass, args);
        } catch (Exception ex) {
            if(ex instanceof InstanceCreateFailureException) {
                throw (InstanceCreateFailureException)ex;
            }
            LOG.error("NX܂ł. name=" + className);
            throw new InstanceCreateFailureException("InstanceFactory::createInstance() failed", ex);
        }
    }
    
    /**
     * w肵NX̃CX^X𐶐B<p>
     * @param objClass 쐬CX^X̃NXIuWFNg
     * @param args RXgN^̈
     * @return 쐬CX^X
     * @since 1.0.2
     */
    public static Object createInstance(Class objClass, Object[] args) {
        
        try {
            Class[] argClasses = new Class[args.length];
            for (int i=0; i<args.length; i++) {
                argClasses[i] = args[i].getClass();
            }
            Constructor con = objClass.getConstructor(argClasses);
            return con.newInstance(args);
        } catch(Exception ex) {
            throw new InstanceCreateFailureException("InstanceFactory::createInstance() failed", ex);
        }
        
    }
}
