/*
 * Copyright 2006 Robbie.JP
 */
package robbie.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import robbie.util.InstanceFactory;

/**
 * 쐬InvocationHandlerBaseNX.<p>
 * ̃NXgāAInvocationHandler̎NX쐬邱Ƃ𐄏܂B
 * <pre>
 * <b>p@</b>
 * ʏ́AProxyFactryƃZbgŎgp܂B
 * Ƃ΁AHogeC^tF[XƁÃC^tF[XHogeImplꍇɂ́A
 * 
 * Hoge hoge = (Hoge)ProxyFactory.createProxy(
 *         Hoge.class,
 *         new BaseInvocationHandler(HogeImpl.class));
 * 
 * ƂɁAHogẽvLVNX쐬܂B
 * 
 * </pre>
 * @since 1.1.1
 */
public class BaseInvocationHandler implements InvocationHandler {

    private static Log LOG = LogFactory.getLog(BaseInvocationHandler.class);
    
    protected Object beanObject = null;
    
    private BaseInvocationHandler() {
        // CX^X͍点Ȃ
    }
    
    /**
     * ProxysNX̃NXw肵InvocationHandler쐬܂B<p> 
     * @param objClass ProxysNX̃NXIuWFNg
     */
    public BaseInvocationHandler(Class objClass) {
        beanObject = InstanceFactory.createInstance(objClass.getName());
    }
    
    /**
     * ProxysNX̃NXƈw肵InvocationHandler쐬܂B<p> 
     * @param objClass ProxysNX̃NXIuWFNg
     * @param args RXgN^̈
     */
    public BaseInvocationHandler(Class objClass, Object[] args) {
        beanObject = InstanceFactory.createInstance(objClass, args);
    }
    
    /**
     * ProxysNX̃CX^Xw肵InvocationHandler쐬܂B<p> 
     * @param obj Proxy̎sNX
     */
    public BaseInvocationHandler(Object obj) {
        beanObject = obj;
    }
    
    /**
     * sĂ܂.<p>
     * ̃NXpgNXŁÃ\bhI[oChĂB
     * ł̓\bhJnOƌŃOo͂sĂ܂B
     * @param proxy ProxỹCX^X
     * @param method s郁\bh`NX
     * @param args \bḧ
     * @return s\bh̖߂l
     */
    public Object invoke(Object proxy, Method method, Object[] args) {
        
        LOG.debug(method.getName() + "\bhJn܂.");
        
        Object obj = null;
        try {
            obj = method.invoke(getBean(), args);
        } catch(Exception ex) {
            ex.printStackTrace();
        }
        
        LOG.debug(method.getName() + "\bhI܂. ߂l" + obj + "ł.");
        return obj;
    }
    
    protected Object getBean() {
        return beanObject;
    }

}
