/*
 * Copyright 2004-2006 Robbie.JP
 */
package robbie.dao.x;

import java.sql.Connection;

import robbie.dao.DaoSysException;
import robbie.dao.DbConnectionUtil;

/**
 * DataSourceResourceNXB<p>
 * typef[^\[X̏ꍇDBResourceB
 */
public class DataSourceResource implements XDbResource {
    
    private static final long serialVersionUID = 5554156609678001644L;
    
    /** f[^\[XJNDI */
    protected String jndiName = null;
    
    /**
     * RXgN^B
     * @param jndiName f[^\[X
     */
    public DataSourceResource(String jndiName) {
        if (jndiName == null) {
            throw new IllegalArgumentException("p[^jndiNameNULLł.");
        }
        this.jndiName = jndiName;
    }
    
    /**
     * RlNVԂ
     * @return ConnectionIuWFNg
     */
    public Connection getConnection() {
        
        try {
            return DbConnectionUtil.getConnectionByDataSource(jndiName);
        } catch(Exception ex) {
            throw new DaoSysException("f[^x[X̃RlNV̎擾Ɏs܂.", ex);
        }
    }
    
    /**
     * \[X[X܂B<p>
     */
    public void release() {
        // ͓ɉȂ
    }
    
    /**
     * toString()̃I[oChB<p>
     * @return ̃CX^X̕\L
     */
    public String toString() {
        return "JNDI NAME=" + jndiName;
    }
}
