/*
 * Decompiled with CFR 0.152.
 */
package robbie.util;

import java.lang.reflect.Constructor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import robbie.util.InstanceCreateFailureException;

public class InstanceFactory {
    private static final Log LOG;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("robbie.util.InstanceFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
    }

    public static Object createInstance(String className) {
        try {
            return Class.forName(className).newInstance();
        }
        catch (ClassNotFoundException ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("\u30af\u30e9\u30b9\u304c\u30c7\u30d5\u30a9\u30eb\u30c8\u306e\u30af\u30e9\u30b9\u30ed\u30fc\u30c0\u3067\u306f\u898b\u3064\u304b\u308a\u307e\u305b\u3093. class=" + className + "] in default class loader."));
                LOG.debug((Object)"Thread.currentThread().getContextClassLoader()\u3092\u4f7f\u7528\u3057\u3066\u30af\u30e9\u30b9\u3092\u691c\u7d22\u3057\u307e\u3059.");
            }
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            return InstanceFactory.createInstance(className, loader);
        }
        catch (Exception ex) {
            LOG.error((Object)("\u30af\u30e9\u30b9\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f. name=" + className));
            throw new InstanceCreateFailureException("InstanceFactory::createInstance() failed", ex);
        }
    }

    public static Object createInstance(String className, ClassLoader loader) {
        try {
            if (loader == null) {
                return InstanceFactory.createInstance(className);
            }
            return Class.forName(className, true, loader).newInstance();
        }
        catch (Exception ex) {
            if (ex instanceof InstanceCreateFailureException) {
                throw (InstanceCreateFailureException)ex;
            }
            LOG.error((Object)("\u30af\u30e9\u30b9\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f. name=" + className));
            throw new InstanceCreateFailureException("InstanceFactory::createInstance() failed", ex);
        }
    }

    public static Object createInstance(String className, Object[] args) {
        try {
            Class<?> objClass = Class.forName(className);
            return InstanceFactory.createInstance(objClass, args);
        }
        catch (ClassNotFoundException ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("\u30af\u30e9\u30b9\u304c\u30c7\u30d5\u30a9\u30eb\u30c8\u306e\u30af\u30e9\u30b9\u30ed\u30fc\u30c0\u3067\u306f\u898b\u3064\u304b\u308a\u307e\u305b\u3093. class=" + className + "] in default class loader."));
                LOG.debug((Object)"Thread.currentThread().getContextClassLoader()\u3092\u4f7f\u7528\u3057\u3066\u30af\u30e9\u30b9\u3092\u691c\u7d22\u3057\u307e\u3059.");
            }
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            return InstanceFactory.createInstance(className, args, loader);
        }
        catch (Exception ex) {
            if (ex instanceof InstanceCreateFailureException) {
                throw (InstanceCreateFailureException)ex;
            }
            LOG.error((Object)("\u30af\u30e9\u30b9\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f. name=" + className));
            throw new InstanceCreateFailureException("InstanceFactory::createInstance() failed", ex);
        }
    }

    public static Object createInstance(String className, Object[] args, ClassLoader loader) {
        try {
            if (loader == null) {
                return InstanceFactory.createInstance(className, args);
            }
            Class<?> objClass = Class.forName(className, true, loader);
            return InstanceFactory.createInstance(objClass, args);
        }
        catch (Exception ex) {
            if (ex instanceof InstanceCreateFailureException) {
                throw (InstanceCreateFailureException)ex;
            }
            LOG.error((Object)("\u30af\u30e9\u30b9\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f. name=" + className));
            throw new InstanceCreateFailureException("InstanceFactory::createInstance() failed", ex);
        }
    }

    public static Object createInstance(Class objClass, Object[] args) {
        try {
            Class[] argClasses = new Class[args.length];
            int i = 0;
            while (i < args.length) {
                argClasses[i] = args[i].getClass();
                ++i;
            }
            Constructor con = objClass.getConstructor(argClasses);
            return con.newInstance(args);
        }
        catch (Exception ex) {
            throw new InstanceCreateFailureException("InstanceFactory::createInstance() failed", ex);
        }
    }
}

