# roap data management module.

import re, string
import datasource

class MatchObject:
    def build_matchobj (self, list):

        mstrlist = []
        matchstr = ""

        for col in list:
            rowrange = col["range"]

            # In order to make it correspond to two or more lines match,
            # '$' is transposed to a new-line sign.

            pattern = col["pattern"]
            pattern = re.sub ("\$$", "\\\\n", pattern)

            tmpptn = string.split (pattern, "(?") 
            tmplist = []
            for ptn in tmpptn:
                ptn = re.sub ("([^\\\\])\\(", "\\1(?:", ptn)
                tmplist.append (ptn)
            pattern = string.join (tmplist, "(?")
                            
            pattern = re.sub ("([^\\\\n])$", "\\1\\\\n", pattern)

            # Range of row has wild card case.
            if rowrange == "+" or rowrange == "*":

                if col["content"] == "yes":
                    matchstr = matchstr + "((?:%s)%s)" % (pattern, rowrange)
                else:
                    matchstr = matchstr + "(?:(?:%s)%s)" % (pattern, rowrange)

            # Range of row has numeric case.
            else:
                try:
                    rowrange = int (rowrange)
                except:
                    print 'Error: invalid literal in range="%s"' % rowrange
                    continue

                for i in range (rowrange):
                    # print "pattern: " + col["pattern"]
                    if col["content"] == "yes":
                        matchstr = matchstr + "(%s)" % pattern
                    else:
                        matchstr = matchstr + "(?:%s)" % pattern

        # print "matchstr: " + matchstr 
        matchstr = re.compile (matchstr, re.M)
        return (matchstr)

    def strip_region (self, region):
        "The blank space of order is deleted."

        lines = ""
        for line in string.split (region, "\n"):
            line = string.strip (line)
            lines = lines + line

        return (lines)

