<?php
/* ========================================================================
 - [modules/admin/community/result.php]
 -      コミュニティ検索結果
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2007/01/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_pager.php';
require_once WEBAPP_LIB_DIR.'wap_admin.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_admin
{
    /**
     * WHERE句
     * @var string
     */
    var $where = '';

    /**
     * ORDER句
     * @var string
     */
    var $order = '';

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN));

        $this->setTemplateFile('admin/community/result.tpl');

        if (preg_match('/complete/i',$_SERVER['REQUEST_URI'])){
            $this->Assign('complete', true);
        } elseif (!empty($_POST['search'])){
            header('Location: '.HTTP_ACTION.'admin/community/result/'.WAP_URI_SEPARATOR.http_build_query($_POST));
            exit();
        }

        // 一括更新
        if ($this->do_querys()){
            header('Location: '.HTTP_ACTION.'admin/community/result/complete/');
            exit();
        }

        $this->set_sort();
        $this->set_condition();
        $this->set_community();

        $avails = array(
            AVAIL_DISABLE=>'無効',
            AVAIL_ENABLE=> '有効',
        );
        $this->Assign('avails', $avails);
    }

    /**
     * 並び替えの設定
     *
     * @access private
     * @return void
     */
    function set_sort()
    {
        $sql=
            'SELECT '.
                'id,'.
                'label '.
            'FROM '.
                DB_PREFIX.'sys_sort '.
            'WHERE '.
                'ref_category = '.SORT_COMMUNITY.' '.
            'ORDER BY '.
                'sort';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $list = array();
        foreach ($result as $value){
            $list[$value['id']] = $value['label'];
        }
        
        $this->Assign('sorts', $list);
    }

    /**
     * 条件データの取得
     *
     * @access private
     * @return string   絞込み句
     **/
    function get_condition()
    {
        /* 絞込条件の取得 */
        $validates = array(
            'avail'=> array(
                'type'=> 'number',
                'option'=> array()
            ),
            'ref_prefecture'=> array(
                'type'=> 'number',
                'option'=> array()
            ),
            'ref_category'=> array(
                'type'=> 'number',
                'option'=> array()
            ),
            'keyword'=> array(
                'type'=> 'string',
                'option'=> array()
            ),
            'ref_sort'=> array(
                'type'=> 'number',
                'option'=> array()
            ),
        );

        return $this->catchCondition($validates);
    }

    /**
     * リストの絞込み
     *
     * @access private
     * @return string   絞込み句
     **/
    function set_condition()
    {
        // 絞込み条件の初期化
        $where = array();
        $conditions = $this->get_condition();


        /* 有効・無効 */
        if (isSet($conditions['avail'])){
            if ($conditions['avail'] != ''){
                $where[] = 'com.avail='.$conditions['avail'];
            }
        } // if (isSet($conditions['avail']))

        /* 活動拠点 */
        if (!empty($conditions['ref_prefecture'])){
            $where[] = 'com.ref_prefecture='.$conditions['ref_prefecture'];
        }
        /* カテゴリ */
        if (!empty($conditions['ref_category'])){
            if (is_array($conditions['ref_category'])){
                $where[] = 'sel.ref_category in('.implode(',',$conditions['ref_category']).')';
            } else {
                $where[] = 'sel.ref_category='.$conditions['ref_category'];
            }
        }
        /* キーワード検索 */
        $keys = array();
        if (!empty($conditions['keyword'])){
            $keywords = explode(' ',$conditions['keyword']);
            foreach ($keywords as $keyword){
                $keys[] = '('.
                    "com.community like '%".$keyword."%'".' OR '.
                    "com.publicity like '%".$keyword."%'".')';
            }
            $where[] = '('.implode(' OR ',$keys) .') ';
        }


        /* 並び替え */
        if (!empty($conditions['ref_sort'])){
            $this->set_order($conditions['ref_sort']);
        }

        
        if (!count($where)){
            return '';
        }
        $this->where = ' AND '. implode(' AND ',$where) .' ';
    }

    /**
     * ORDER句の設定
     *
     * @access private
     * @pram integer $id
     * @return void
     */
    function set_order($id)
    {
        $sql=
            'SELECT '.
                'direction '.
            'FROM '.
                DB_PREFIX.'sys_sort '.
            'WHERE '.
                'id = '.$id;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        $this->order = empty($result['direction'])?
                        '':'ORDER BY '.$result['direction'];
    }

    /**
     * コミュニティの設定
     *
     * @access private
     * @return void
     */
    function set_community()
    {
        $offset = RKT_validate::getSafety('number', 'offset');
        $_SESSION['offset'] = $offset;

        $objpgr = new RKT_pager($this->objdb, $offset, LIMIT_COMMUNITY);    // クラスの生成
        $sql=
            'SELECT '.
                'com.id as id,'.
                'com.avail as avail,'.
                'com.community as community,'.
                'com.total as total,'.
                'com.publicity as publicity,'.
                'prf.prefecture as prefecture,'.
                'pic.thumbnail as src,'.
                'pic.t_width as width,'.
                'pic.t_height as height '.
            'FROM '.
                DB_PREFIX.'com_community com '.
                    'LEFT JOIN '.DB_PREFIX.'com_picture pic '.
                    'ON com.id = pic.ref_community AND '.
                       'pic.status = '.STATUS_PICTURE_COMMUNITY.' '.
                    'LEFT JOIN '.DB_PREFIX.'com_select sel '.
                    'ON com.id = sel.ref_community,'.
                DB_PREFIX.'ara_prefecture prf '.
            'WHERE '.
                'prf.id = com.ref_prefecture '.
                $this->where.' '.
            'GROUP BY '.
                'com.id '.
                $this->order;
        $objpgr->setSql($sql);

        $page = array(
            'infos'=> $objpgr->getInfo(),
            'links'=> $objpgr->getPager()
        );
        $this->Assign('page', $page);

        $result = $objpgr->getValues();

        $this->Assign('list', $result);
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return boolean
     */
    function do_querys()
    {
        if (empty($_POST['manips'])){
            return false;
        }
        foreach ($_POST['edits'] as $values){
            $this->update_query($values);
        }
        return true;
    }

    /**
     * データの更新処理
     *
     * @access private
     * @param array $values
     * @return integer  データ操作結果
     */
    function update_query($values)
    {
        $id    = RKT_validate::number($values['id'])?$values['id']:0;
        $id    = $this->objdb->quote($id);
        $avail = empty($values['avail'])?AVAIL_DISABLE:AVAIL_ENABLE;

        $sql =
            'UPDATE '.
                DB_PREFIX.'com_community '.
            'SET '.
                'avail = '.$avail.' '.
            'WHERE '.
                'id = '.$id;
        return $this->objdb->query($sql);
    }
} // webapp
?>
