<?php
/* ========================================================================
 - [sns_config.php]
 -      各種定義
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2007/07/23] CHUNK文字数を追加
 -      [2007/07/07] SMTPの設定を追加
 -      [2007/07/05] Smarty設定ディレクトリパスの変更
 -      [2007/06/17] アクセス権限定義を追加
 -      [2007/06/08] manip(ulation)用DBクラス保存ディレクトリパス定義を追加
 -      [2007/05/28] 管理者と初期ユーザーを統合
 -      [2007/04/21] 問合せ対応状況を追加
 -      [2007/02/12] STATUS_COMMUNITYをビットフラグ
 -      [2007/02/12] VISIBILITYをビットフラグ
 -      [2007/02/02] コンテンツ記事の表示開始年を追加
 -      [2007/02/02] 最新情報表示期間定義を追加
 -      [2007/02/02] 日記コメント定義を追加
 -      [2007/01/29] 日記のフォーマット定義を追加
 -      [2007/01/08] PathInfo未使用時用のFormメソッドの定義を追加
 -      [2006/09/29] タイムアウト時間設定 WAP_TIME_LIMIT を追加
 -      [2006/09/21] .htaccess、PathInfoに依存しない処理を追加
 -      [2006/09/17] WAP_PDF_SUPPORTを追加
 -      [2006/09/12] SMARTY用定数名を変更
 -      [2006/09/12] テンポラリイメージ保存ディレクトリパス CACHE_IMG_DIR 追加
 -      [2006/09/05] MySQL用定数を追加
 -      [2006/09/04] コンテンツ一覧表示数制限 LIMIT_CONTENTS 追加
 -      [2006/08/30] 招待していなる／いないフラグ 追加
 -      [2006/08/30] 一覧表示数制限 LIMIT_TILE 追加
 -      [2006/08/29] アーカイブスの保存先パス追加
 -      [2006/08/26] メールボックスのディレクトリ追加
 -      [2006/08/22] wap_config.php から sns_config.phpへ
 -      [2006/07/10] 作成
 - ======================================================================== */

if (!defined('_SNS_CONFIG_PHP_')){
define('_SNS_CONFIG_PHP_',true);

/* ---------------------------------------- */
/* システム情報 */
define('WAP_ADMINISTRATOR', 'admin@example.com');                   // 管理者メールアドレス
define('WAP_SYSTEM_NAME', 'rktSNS');                                // システム名
define('WAP_COOKIE_DOMAIN','.example.com');                         // クッキー発行ドメイン
define('BASE_URL', 'http://sns.example.com/');                      // ベースURL
define('SSL_URL', 'https://sns.example.com/');                      // SSLプロトコル用アクション
define('PATH_INFO_KEY', 'QUERY_STRING');                               // パスインフォ用添え字
define('WAP_PASS_SEED', 'exampleexampleexample');                   // 暗号等に使われる種
define('WAP_PASS_PHRASE', 'exampleexampleexampleexampleexam');      // パスフレーズ
define('COPYRIGHT', "Copyright (C) 2006 `example.com' All Rights Reserved.");   // 制作著作
define('PHP_COMMAND_PATH', '/usr/local/bin/php');                   // PHPコマンドパス
define('WAP_INVITE', TRUE);                                         // 招待制度
define('WAP_SNS_VISIBILITY', FALSE);                                // SNS全体の公開設定
define('WAP_PDF_SUPPORT', FALSE);                                   // パスインフォ用添え字
define('WAP_ACTION_STYLE', '.php?');                                // フロントコントローラのスタイル
define('WAP_URI_SEPARATOR', '&');                                   // URIとパラメータの区切り
define('WAP_METHOD', 'get');                                        // フォームアクションメソッド

/* ---------------------------------------- */
/* アマゾンWebサービス用の設定 */
define('AMAZON_TOKEN',       '0EECRRRCGRKWFD0DGM82');               // サービスアカウントキー
define('AMAZON_ASSOCIATEID', 'rakutonet-22');                       // アクセスID
define('AMAZON_BASEURL',     'http://xml-jp.amznxslt.com/onca/xml2');
define('AMAZON_LOCALE',      'jp');

/* ---------------------------------------- */
/* データベース */
define('WAP_DB_DRIVER', 'sqlite');                                  // データベースドライバ
define('WAP_DB_NAME', 'rktsns');                                    // データベース名
define('WAP_DB_HOST', 'localhost');                                 // データベースホスト
define('WAP_DB_USER', 'mysql_user');                                // 接続ユーザー
define('WAP_DB_PASSWD', 'passwd');                                  // パスワード
define('DB_PREFIX',    'sns_');                                     // テーブル名の接頭語
define('DB_NAME_HOST', 'dbname='.WAP_DB_NAME.';host='.WAP_DB_HOST); // データベース名とホスト名
define('USE_SET_NAMES', '0');                                       // SET NAMESを使用するか

/* ---------------------------------------- */
/* 画像加工ドライバ */
define('IMAGEMAGICK_PATH', '/usr/local/bin/');                      // ImageMagickのパス
define('IMAGE_DRIVER', 'gd');                                       // 使用する画像加工ドライバ

/* ---------------------------------------- */
/* SMTPメール設定 */
define('USED_SMTP', FALSE);                                         // SMTPの使用
define('SMTP_HOST', 'mail.example.com');                            // SMTPホスト
define('SMTP_PORT', 25);                                            // SMTPポート
define('SMTP_AUTH', FALSE);                                         // SMTP認証
define('SMTP_ACCOUNT', 'send@example.com');                         // SMTPアカウント
define('SMTP_PASSWORD', 'passwd');                                  // SMTPパスワード

/* ---------------------------------------- */
/* POP3メール設定 */
define('POP3_HOST', 'mail.example.com');                            // POP3ホスト
define('POP3_ACCOUNT', 'post@example.com');                         // POP3アカウント
define('POP3_PASSWORD', 'passwd');                                  // POP3パスワード

/* ---------------------------------------- */
/* メールボックス設定 */
define('MAIL_BOX_DIR', '');                                         // メールボックスのディレクトリ

/* ---------------------------------------- */
/* デバッグモード */
define('DEBUG_ENV', FALSE);                                         // デバッグモード
if (DEBUG_ENV){
    error_reporting (E_ALL);
} else {
    error_reporting (E_ALL ^ E_WARNING ^ E_NOTICE);
}

/* ---------------------------------------- */
/* エンコード・マルチバイト設定 */
define('ENCODE_TYPE', 'UTF-8');                                     // エンコードタイプ
ini_set('default_charset', ENCODE_TYPE);                            // マルチバイトデフォルト設定
mb_language('Japanese');                                            // 使用言語設定
mb_internal_encoding(ENCODE_TYPE);                                  // 内部エンコード設定

/* ---------------------------------------- */
/* rktSNSの各種ディレクトリ設定 */
define('BASE_DIR', dirname(__FILE__).DIRECTORY_SEPARATOR);          // ベースディレクトリ設定
define('LIB_DIR',BASE_DIR.'libs'. DIRECTORY_SEPARATOR);             // ライブラリパス
define('WORK_DIR',BASE_DIR.'works'.DIRECTORY_SEPARATOR);            // 作業ディレクトリパス
define('DOCUMENT_DIR',BASE_DIR.'htdocs'.DIRECTORY_SEPARATOR);       // 各種ファイルの保存先パス
define('CACHE_DIR', WORK_DIR.'cache'. DIRECTORY_SEPARATOR);         // キャッシュパス
define('COMPILE_DIR', WORK_DIR.'templates_c'. DIRECTORY_SEPARATOR); // コンパイル済みファイルの保存先パス
define('DB_DIR', WORK_DIR.'dbs'.DIRECTORY_SEPARATOR);               // データベース保存ディレクトリパス
define('THEME_DIR', WORK_DIR.'themes'.DIRECTORY_SEPARATOR);         // デザインテーマ保存ディレクトリパス
define('RESOURCE_DIR',DOCUMENT_DIR.'resource'.DIRECTORY_SEPARATOR); // リソースファイルの保存先パス
define('CACHE_IMG_DIR', CACHE_DIR.'img'.DIRECTORY_SEPARATOR);       // テンポラリイメージ保存ディレクトリパス
define('MANIP_DIR', WORK_DIR.'manips'.DIRECTORY_SEPARATOR);         // manip(ulation)用DBクラス保存ディレクトリパス
define('ARCHIVES_DIR','');                                          // アーカイブスの保存先パス
define('MEMBER_DIR',ARCHIVES_DIR.'account'.DIRECTORY_SEPARATOR);        // アーカイブスの保存先パス
define('COMMUNITY_DIR',ARCHIVES_DIR.'community'.DIRECTORY_SEPARATOR);   // アーカイブスの保存先パス

define('ERROR_LOG_FILE', 
    WORK_DIR.'logs'.DIRECTORY_SEPARATOR .'error.log');              // エラーログファイル
define('SNS_DB_FILE', DB_DIR.'sns.db');                             // sns本体DBファイル

/* ---------------------------------------- */
/* BLOBドライバ */
define('BLOB_DRIVER', 'db');                                        // 使用する画像加工ドライバ
define('BLOB_DB_FILE', DB_DIR.'blob.db');                           // バイナリ保存DBファイル

/* ---------------------------------------- */
/* Smarty（テンプレートエンジン）の定義部分 */
define('SMARTY_DIR' ,LIB_DIR.'Smarty'. DIRECTORY_SEPARATOR);            // Smartyライブラリパス
define('SMARTY_CONFIG_DIR', WORK_DIR.'configs'.DIRECTORY_SEPARATOR);    // Smartyコンフィグパス
/* ---------------------------------------- */

/* ---------------------------------------- */
/* システム設定 */
define('SNS_ACC_ADMIN', 1);                                         // 管理者ユーザーID
define('SNS_ACC_GHOST', 1);                                         // ゴーストユーザーID
define('WAP_START_AGE', 1940);                                      // 年齢初期値
define('WAP_START_YEAR', 2006);                                     // スタート年
define('WAP_DEFAULT_NUMBER_BLOG',2);                                // パスインフォ引数の開始番号
define('ALLOWABLE_TAGS',
    '<a><br><em><font><img><li><ol><span>'.
    '<strike><strong><u><ul><p><div>');                             // 入力を許可するタグ
define('WAP_TIME_LIMIT',3600);                                      // タイムアウト時間を設定

/* ---------------------------------------- */
/* ファイルの保存先URL */
define('ACTION_ARCHIVES','archives'.WAP_ACTION_STYLE);              // 保存ファイルの出力
define('ARCHIVES_PATH', ACTION_ARCHIVES.'/');                       // 各種ファイルの保存先URL
define('ARCHIVES_MEMBER_PATH', ARCHIVES_PATH.'member/');            // 会員用ファイルの保存先URL
define('ARCHIVES_COMMUNITY_PATH', ARCHIVES_PATH.'community/');      // コミュニティ用ファイルの保存先URL
define('ARCHIVES_UPLOAD_PATH', ARCHIVES_PATH.'upload/');            // 一時アップロード先

/* ---------------------------------------- */
/* アクセス権限 */
define('WAP_ACC_ADMIN',1);                                          // 管理者権限
define('WAP_ACC_GUEST',2);                                          // ゲストユーザー権限
define('WAP_ACC_MEMBER',3);                                         // 会員ユーザー権限

/* ---------------------------------------- */
/* 有効性 */
define('AVAIL_DISABLE', 0);                                         // 無効
define('AVAIL_ENABLE',  1);                                         // 有効
define('AVAIL_PENDING', 2);                                         // 認証待ち

/* ---------------------------------------- */
/* 招待リレーション */
define('INVITE_DISABLE', 0);                                        // 招待していない
define('INVITE_ENABLE',  1);                                        // 招待していなる

/* ---------------------------------------- */
/* メッセージ */
define('MESSAGE_INBOX',1);                                          // 受信箱
define('MESSAGE_SENT', 2);                                          // 送信済み
define('MESSAGE_DRAFT',3);                                          // 下書き
define('MESSAGE_TRASH',4);                                          // ゴミ箱

define('MESSAGE_LABEL_INBOX','受信箱');
define('MESSAGE_LABEL_SENT', '送信済み');
define('MESSAGE_LABEL_DRAFT','下書き');
define('MESSAGE_LABEL_TRASH','ゴミ箱');

define('MESSAGE_FLAG_UNREAD',1);                                    // 未読メッセージ
define('MESSAGE_FLAG_READ',  2);                                    // 既読メッセージ
define('MESSAGE_FLAG_RETURN',3);                                    // 返信メッセージ

/* ---------------------------------------- */
/* 表示の権限 */
define('VISIBILITY_HIDDEN',   0x01);                                // 公開しない
define('VISIBILITY_PUBLIC',   0x02);                                // ネット上に公開
define('VISIBILITY_PROTECTED',0x04);                                // 会員に公開
define('VISIBILITY_FRIEND',   0x08);                                // お友達に公開
define('VISIBILITY_PRIVATE',  0x08);                                // メンバーに公開

define('VISIBILITY_OPEN',     0x06);                                // 会員に公開まで
define('VISIBILITY_CLOSE',    0x0E);                                // お友達に公開まで

define('VISIBILITY_ALL',      0xFF);                                // 全部

define('VISIBILITY_LABEL_PUBLIC',   'ネット上に公開');
define('VISIBILITY_LABEL_PROTECTED','会員に公開');
define('VISIBILITY_LABEL_FRIEND',   'お友達に公開');
define('VISIBILITY_LABEL_PRIVATE',  'メンバーに公開');
define('VISIBILITY_LABEL_HIDDEN',   '公開しない');

define('VISIBILITY_LABEL_PUBLIC_ENTRY',  '参加条件はありません(ネット上に公開)');
define('VISIBILITY_LABEL_PRIVATE_ENTRY', '参加には管理者の承認が必要です (会員に公開)');
define('VISIBILITY_LABEL_HIDDEN_ENTRY',  '参加には管理者の承認が必要です(非公開)');

/* ---------------------------------------- */
/* アクセス権限 */
define('PERMISSION_ADMIN',    1);                                   // 管理者のみ
define('PERMISSION_MEMBER',   2);                                   // 会員まで
define('PERMISSION_GUEST',    3);                                   // ゲスト

/* ---------------------------------------- */
/* ニュースの配信の状態 */
define('NEWS_STOP',   0);                                           // 配信停止
define('NEWS_DAILY',  1);                                           // 毎日配信
define('NEWS_WEEKLY', 2);                                           // 月・木配信

/* ---------------------------------------- */
/* メールの送信状況 */
define('STATAS_MAIL_ROUGH', 1);                                     // 下書き
define('STATAS_MAIL_SEND',  2);                                     // 送信
define('STATAS_MAIL_SENT',  3);                                     // 送信済み

define('STATAS_MAIL_LABEL_ROUGH', '下書き');
define('STATAS_MAIL_LABEL_SEND',  '送信');
define('STATAS_MAIL_LABEL_SENT',  '送信済み');

/* ---------------------------------------- */
/* コンテンツカテゴリ */
define('ITEM_CATEGORY_STATIC',   1);                                // 固定コンテンツ
define('ITEM_CATEGORY_INFO',     2);                                // お知らせ
define('ITEM_CATEGORY_QUESTION', 3);                                // アンケート

/* ---------------------------------------- */
/* 画像の状態 */
define('STATUS_PICTURE_TEMP',      0);                              // テンポラリ
define('STATUS_PICTURE_COMMUNITY', 1);                              // コミュニティ画像
define('STATUS_PICTURE_TOPIC',     2);                              // トピック画像
define('STATUS_PICTURE_COMMENT',   3);                              // コメント画像

/* ---------------------------------------- */
/* 写真の状態 */
define('STATUS_PHOTO_SUB',  0);                                     // サブ
define('STATUS_PHOTO_MAIN', 1);                                     // メイン

/* ---------------------------------------- */
/* トピックの状態 */
define('STATUS_TOPIC_BULLETIN', 1);                                 // 掲示板用
define('STATUS_TOPIC_EVENT',    2);                                 // イベント用
define('STATUS_TOPIC_ITEM',     3);                                 // コミュニティ記事
define('STATUS_TOPIC_ENQUETE',  4);                                 // コミュニティアンケート

/* ---------------------------------------- */
/* レビューのタイプ */
define('REVIEW_TYPE_AMAZON',   1);                                  // アマゾン

/* ---------------------------------------- */
/* 名簿の状態 */
define('STATUS_COMMUNITY_ADMIN',   0x01);                           // 管理人
define('STATUS_COMMUNITY_MEMBER',  0x02);                           // メンバー
define('STATUS_COMMUNITY_REFUSAL', 0x04);                           // 拒絶
define('STATUS_COMMUNITY_REQUEST', 0x08);                           // 参加希望者
define('STATUS_COMMUNITY_CHANGE',  0x10);                           // 管理人交代

define('STATUS_COMMUNITY_MEMBERS', 0x1B);                           // メンバー全部

define('STATUS_COMMUNITY_LABEL_ADMIN',  '管理人');
define('STATUS_COMMUNITY_LABEL_MEMBER', 'メンバー');
define('STATUS_COMMUNITY_LABEL_REFUSAL','拒絶');
define('STATUS_COMMUNITY_LABEL_REQUEST','参加希望者');
define('STATUS_COMMUNITY_LABEL_CHANGE', '管理人交代');

/* ---------------------------------------- */
/* フォームの種類 */
define('FORM_TYPE_TEXT',    1);                                     // テキスト
define('FORM_TYPE_TEXTAREA',2);                                     // テキストエリア
define('FORM_TYPE_SELECT',  3);                                     // 選択リスト
define('FORM_TYPE_CHECKBOX',4);                                     // チェックボックス
define('FORM_TYPE_RADIO',   5);                                     // ラジオボタン
define('FORM_TYPE_DATE',    6);                                     // 日付リスト

/* フォームの公開設定 */
define('VISIBILITY_VISIBLE',    1);                                 // 常に表示
define('VISIBILITY_USER_SELECT',2);                                 // ユーザー選択

/* ---------------------------------------- */
/* 検索結果の並び替えカテゴリ */
define('SORT_FRIEND',    1);                                        // 友達一覧
define('SORT_COMMUNITY', 2);                                        // コミュニティ一覧
define('SORT_EVENT',     3);                                        // イベント一覧
define('SORT_DIARY',     4);                                        // 日記一覧
define('SORT_REVIEW',    5);                                        // レビュー一覧
define('SORT_FORUM',     6);                                        // フォーラム一覧

define('LIMIT_ROWS',      10);                                      // 各一覧
define('LIMIT_TILE',      50);                                      // タイル表示一覧
define('LIMIT_FRIEND',    20);                                      // 友達一覧
define('LIMIT_COMMUNITY', 20);                                      // コミュニティ一覧
define('LIMIT_EVENT',     10);                                      // イベント一覧
define('LIMIT_DIARY',     10);                                      // 日記一覧
define('LIMIT_TOPIC',     20);                                      // トピック一覧
define('LIMIT_COMMENT',   20);                                      // コメント一覧
define('LIMIT_REVIEW',    10);                                      // レビュー一覧
define('LIMIT_FORUM',     20);                                      // フォーラム一覧
define('LIMIT_FOOTPRINT', 20);                                      // あしあと一覧
define('LIMIT_CONTENTS',  20);                                      // コンテンツ一覧

/* ---------------------------------------- */
/* 画像サイズ */
define('PHOTO_MAX_SIZE',   600);                                    // 保存用画像上限
define('PHOTO_LARGE_SIZE', 180);                                    // 各種表示画像上限
define('PHOTO_SMALL_SIZE',  76);                                    // サムネイル用画像上限
define('NOPHOTO_LARGE', 'resource/img/common/nophoto.gif');         // 180pix 非表示画像
define('NOPHOTO_SMALL', 'resource/img/common/nophoto_s.gif');       // 76pix 非表示画像

/* ---------------------------------------- */
/* 友達名簿の状態 */
define('STATUS_FRIEND_THROW',   1);                                 // 友達申請
define('STATUS_FRIEND_CONNECT', 2);                                 // 友達
define('STATUS_FRIEND_INVITE',  3);                                 // 友達招待
define('STATUS_FRIEND_REFUSAL', 4);                                 // 拒絶

/* ---------------------------------------- */
/* スポンサー表示位置 */
define('POSITION_SPONSOR_HEAD',   1);                               // ヘッダー部位
define('POSITION_SPONSOR_MIDDLE', 2);                               // 中央部位
define('POSITION_SPONSOR_SIDE',   3);                               // 側面部位

/* ---------------------------------------- */
/* 問合せ対応状況 */
define('STATAS_INQUIRE_NEW',        1);                             // 問合せ
define('STATAS_INQUIRE_PENDING',    2);                             // 検討中
define('STATAS_INQUIRE_RESPONDED',  3);                             // 対応済み
define('STATAS_INQUIRE_TRASH',      4);                             // ゴミ箱

define('STATAS_INQUIRE_LABEL_NEW',        '問合せ');
define('STATAS_INQUIRE_LABEL_PENDING',    '検討中');
define('STATAS_INQUIRE_LABEL_RESPONDED',  '対応済み');
define('STATAS_INQUIRE_LABEL_TRASH',      'ゴミ箱');

/* ---------------------------------------- */
/* 日記のフォーマット */
define('DIARY_FORMAT_PLAIN', 1);                                    // デフォルト
define('DIARY_FORMAT_HTML',  2);                                    // HTML形式

/* 日記のコメント */
define('COMMENT_FLAG_UNREAD',1);                                    // 未読メッセージ
define('COMMENT_FLAG_READ',  2);                                    // 既読メッセージ

/* 表示期間 */
define('TERM_MYHOME_NEWS', '-2 weeks');                             // Myホームの最新リストの期間

/* ---------------------------------------- */
/* RKTフレームワーク用定義 */
define('RKT_SEED',WAP_PASS_SEED);                                   // 暗号等に使われる種
define('RKT_PASS_PHRASE', WAP_PASS_PHRASE);                         // パスフレーズ
define('RKT_ACC_ADMIN',WAP_ACC_ADMIN);                              // アクセス権限:管理者
define('RKT_ACC_DEFAULT',WAP_ACC_GUEST);                            // アクセス権限:デフォルト
define('RKT_ACCOUNT_CLASS','account');                              // アカウントクラス名
define('RKT_DB_DRIVER', WAP_DB_DRIVER);                             // デフォルトDBドライバ
define('RKT_DSN', WAP_DB_DRIVER.':'.DB_NAME_HOST);                  // デフォルトDB DSN
define('RKT_BLOB_DSN', WAP_DB_DRIVER.':'.DB_NAME_HOST);             // デフォルトDB BLOB DSN
define('RKT_DB_USER',  WAP_DB_USER);                                // デフォルトDBユーザー
define('RKT_DB_PASSWD',WAP_DB_PASSWD);                              // デフォルトDBパスワード
define('RKT_TBL_ACCOUNT',DB_PREFIX.'act_account');                  // アカウントテーブル名
define('RKT_TBL_AUTOLOGIN',DB_PREFIX.'act_autologin');              // 自動ログインテーブル名
define('RKT_TBL_SESSION',DB_PREFIX.'sys_sessions');                 // セッションのテーブル名
define('RKT_TBL_BLOB',DB_PREFIX.'sys_blob');                        // Binary Large OBjectテーブル名
define('RKT_CHUNK_NUMBER', 18);                                     // CHUNK文字数

define('BLOB_PARAM', RKT_BLOB_DSN);                                 // BLOB用引数

} // (!defined('_SNS_CONFIG_PHP_'));
?>