<?php
/* ========================================================================
 - [works/manips/{$tbl_name}.php]
 -      {$tbl_name}テーブルクラス
 -      Copyright (c) 2005-2007 Yujiro Takahashi
 - ライセンス:
 -      This source file is subject to version 3.0 of the PHP license,
 -      that is available at http://www.php.net/license/3_0.txt
 -      If you did not receive a copy of the PHP license and are unable 
 -      to obtain it through the world-wide-web, please send a note to 
 -      license@php.net so we can mail you a copy immediately.  
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/
 - 更新履歴：
 -      [{$date}]    作成
 - ======================================================================== */

require_once LIB_DIR.'rkt_db.php';

/**
 * {$tbl_name}テーブルクラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package {$tbl_name}
 * @access public
 * @version 1.0
 */
class {$tbl_name}
{
    /**
     * テーブル名
     * @var string
     */
    var $tbl_name = '{$tbl_name}';

    /**
     * プライマリキー
     * @var string
     */
    var $primary_key = '{$primary_key}';

    /**
     * 項目
     * @var array
     */
    var $column = array();

    /**
     * 入力条件
     * @var array
     */
    var $condition = array();

    /**
     * DB接続オブジェクト
     * @var object
     */
    var $objdb = null;

    /**
     * ステートメントオブジェクト
     * @var object
     */
    var $objsta = null;

    /**
     * コンストラクタ
     *
     * @access public
     * @param integer $cur_id カレントID
     */
    function {$tbl_name}($cur_id)
    {
        $this->objdb  = RKT_db::getInstance();
        $this->cur_id = $cur_id;
        $this->init_column();
        
        if ($this->set_old_value()){
            $this->set_insert();
        } else {
            $this->set_update();
        }
        $this->new_values = $this->old_values;
    }

    /**
     * 項目の定義
     *
     * @access private
     * @param string $key
     * @param mixed $value
     */
    function init_column()
    {
        $this->column = array(
{foreach $columns}
            '{$_row.column}'=> array(
                'column'=>  '{$_row.column}',
                'type'=>    '{$_row.type}',
                'pdo_type'=>{$_row.pdo_type},
                'option'=>  {$_row.option},
                'required'=>{$_row.required},
                'effect'=>  array('RKT_validate', 'escape_character'),
            ),
{/foreach}
        );
    }

    /**
     * 値の設定
     *
     * @access public
     * @param string $key
     * @param mixed $value
     */
    function setValue($key,$value)
    {
        $this->new_values[$key] = $value;
    }

    /**
     * 入力条件の取得
     *
     * @access public
     * @param array $skip
     * @return array
     */
    function getCondition($skip=array())
    {
        $validates = array();
        foreach ($this->column as $key=>$value){
            if (!in_array($key,$skip)){
                $validates[$key] = $value;
            }
        }

        return $validates;
    }

    /**
     * テーブル操作実行
     *
     * @access public
     * @return boolean
     */
    function manip()
    {
        foreach ($this->column as $key=>$info){
            $value = empty($this->new_values[$key])?
                            $this->old_values[$key]:$this->new_values[$key];
            $type  = $info['pdo_type'];
            $this->objsta->bindParam(':'.$key, $value, $type);
        }

        $result = $this->objsta->execute();
        if ($result){
            if (empty($this->cur_id)){
                $this->cur_id = $this->objdb->lastInsertId($this->primary_key);
            }
        }
        return $result;
    }

    /**
     * 初期値を取得する
     *
     * @access private
     * @return boolean
     */
    function set_old_value()
    {
        $sql =
            'SELECT '.
                '* '.
            'FROM '.
                $this->tbl_name.' '.
            'WHERE '.
                $this->primary_key.'='.$this->objdb->quote($this->cur_id);
        $stmt = $this->objdb->prepare($sql);
        $stmt->execute(); 
        $this->old_values = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        if (!$this->old_values){
            $this->old_values = array();
            return false;
        }
        return true;
    }

    /**
     * 挿入処理
     *
     * @access private
     * @return void
     */
    function set_insert()
    {
        $sql =
            'INSERT INTO '.
                '{$tbl_name} ('.
                    '{$cs_columns}'.
                ') VALUES ('
                    '{$bind_columns}'.
                ')';
        $this->objsta = $this->objdb->prepare($sql);
    }

    /**
     * 更新処理
     *
     * @access private
     * @return void
     */
    function set_update()
    {
        $sql =
            'UPDATE '.
                '{$tbl_name} '.
            'SET '.
                '{$set_columns} '.
            'WHERE '.
                '{$primary_key} = :{$primary_key}';
        $this->objsta = $this->objdb->prepare($sql);
    }

    /**
     * 行の削除
     *
     * @access private
     * @return void
     */
    function set_delete()
    {
        $sql =
            'DELETE FROM '.
                '{$tbl_name} '.
            'WHERE '.
                '{$primary_key} = :{$primary_key}';
        $this->objsta = $this->objdb->prepare($sql);
    }
} // manip_sqliteの終了
?>