<?php
/* ========================================================================
 - [libs/rktManip/manip_create.php]
 -      manip(ulation)用DBクラス生成
 -      Copyright (c) 2005-2007 Yujiro Takahashi
 - ライセンス:
 -      This source file is subject to version 3.0 of the PHP license,
 -      that is available at http://www.php.net/license/3_0.txt
 -      If you did not receive a copy of the PHP license and are unable 
 -      to obtain it through the world-wide-web, please send a note to 
 -      license@php.net so we can mail you a copy immediately.  
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/
 - 更新履歴：
 -      [2007/06/08]    作成
 - ======================================================================== */

require_once LIB_DIR.'rkt_db.php';
require_once LIB_DIR.'rkt_template.php';

/**
 * manipulation用DBクラス生成
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package RKT_sqlite
 * @access public
 * @version 1.0
 */
class manip_create
{
    /**
     * DB接続オジェクト
     * @var object
     */
    var $objdb = null;

    /**
     * テンプレートオジェクト
     * @var object
     */
    var $objtmp = null;

    /**
     * manipドライバオジェクト
     * @var object
     */
    var $objmdr = null;

    /**
     * テーブル名
     * @var string
     */
    var $tables = '';

    /**
     * 生成クラスコード
     * @var string
     */
    var $buffer = null;

    /**
     * コンストラクタ
     *
     * @access public
     * @param string $tbl_name テーブル名
     */
    function manip_create($tbl_name='')
    {
        $this->objdb  = RKT_db::getInstance();
        $this->objtmp = new RKT_template(LIB_DIR.'rktManip/manip_template.php');

        include_once LIB_DIR.'rktManip/manip_'.RKT_DB_DRIVER.'.php';
        $classname = 'manip_'.RKT_DB_DRIVER;

        $this->objmdr =& new $classname($this->objdb);
        if (empty($tbl_name)){
            $this->tables = $this->objmdr->getTables();
        } else {
            $this->tables[] = $tbl_name;
        }
    }

    /**
     * テーブルクラス作成実行
     *
     * @access public
     * @return integer 実行結果
     */
    function execute()
    {
        foreach ($this->tables as $tbl_name){
            $this->objmdr->setTableName($tbl_name);
            $this->column  = $this->objmdr->parseColumns();

            $this->primary_key = $this->objmdr->getPrimaryKey();

            $this->objtmp->assign('tbl_name',$tbl_name);
            $this->objtmp->assign('primary_key',$this->primary_key);
            $this->objtmp->assign('date',date('Y/m/d H:i:s'));

            $this->set_columns();
            $this->set_sql_columns();

            $this->objtmp->parse();
            $this->objtmp->save(MANIP_DIR.$tbl_name.'.php');
            $this->objtmp->clearAassign();
        }
    }

    /**
     * 配列から文字列へ
     *
     * @access private
     * @return void
     */
    function array2string($array)
    {
        if (empty($array)){
            return 'array()';
        }
        if (!is_array($array)){
            return 'array()';
        }

        $row = array();
        foreach ($array as $key=>$value){
            $row[] = "'".$key."'=>'".$value."'";
        }

        return 'array('.implode(',', $row).')';
    }

    /**
     * 項目の設定
     *
     * @access private
     * @return void
     */
    function set_columns()
    {
        $columns = array();
        foreach ($this->column as $key=>$value){
            $columns[] = array(
                'column'=>  $key,
                'type'=>    $value['type'],
                'pdo_type'=>$value['pdo_type'],
                'option'=>  $this->array2string($value['option']),
                'required'=>($value['required'])?'TRUE':'FALSE',
            );
        }
        $this->objtmp->assign('columns', $columns);
    }

    /**
     * SQL用項目文字列設定
     *
     * @access private
     * @return void
     */
    function set_sql_columns()
    {
        $keys = array_keys($this->column);
        $bind = array();
        $sets = array();

        foreach ($keys as $key){
            $bind[] = ':'.$key;
            $sets[] = $key.' = :'.$key;
        }

        $this->objtmp->assign('cs_columns',   implode(',', $keys));
        $this->objtmp->assign('bind_columns', implode(',', $bind));
        $this->objtmp->assign('set_columns',  implode(',', $sets));
    }
} // manip_sqliteの終了
?>