<?php
/* ========================================================================
 - [modules/public/friend/search.php]
 -      友達検索
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/07/29] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once WEBAPP_LIB_DIR.'wap_public.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_public
{
    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        $this->setTemplateFile('public/friend/search.tpl');
        $this->addJavas('prototype.js');
        $this->addJavas('prefecture.js');

        $this->set_prefecture();
        $this->set_sex();
        $this->set_blood();
        $this->set_married();
        $this->set_enquete();
    }

    /**
     * 都道府県の設定
     *
     * @access private
     * @return void
     */
    function set_prefecture()
    {
        $sql=
            'SELECT '.
                'id,'.
                'prefecture '.
            'FROM '.
                DB_PREFIX.'ara_prefecture '.
            'ORDER BY '.
                'id';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $list = array();
        foreach ($result as $value){
            $list[$value['id']] = $value['prefecture'];
        }
        
        $this->Assign('prefectures',$list);
    }

    /**
     * 性別の設定
     *
     * @access private
     * @return void
     */
    function set_sex()
    {
        $sql=
            'SELECT '.
                'id,'.
                'sex '.
            'FROM '.
                DB_PREFIX.'act_sex '.
            'ORDER BY '.
                'id';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $list = array();
        foreach ($result as $value){
            $list[$value['id']] = $value['sex'];
        }
        
        $this->Assign('sexs',$list);
    }

    /**
     * 血液型の設定
     *
     * @access private
     * @return void
     */
    function set_blood()
    {
        $sql=
            'SELECT '.
                'id,'.
                'blood '.
            'FROM '.
                DB_PREFIX.'act_blood '.
            'ORDER BY '.
                'id';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $list = array();
        foreach ($result as $value){
            $list[$value['id']] = $value['blood'];
        }
        
        $this->Assign('bloods',$list);
    }

    /**
     * 結婚についての設定
     *
     * @access private
     * @return void
     */
    function set_married()
    {
        $sql=
            'SELECT '.
                'id,'.
                'married '.
            'FROM '.
                DB_PREFIX.'act_married '.
            'ORDER BY '.
                'id';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $list = array();
        foreach ($result as $value){
            $list[$value['id']] = $value['married'];
        }
        
        $this->Assign('marrieds',$list);
    }

    /**
     * アンケートの設定
     *
     * @access private
     * @return void
     */
    function set_enquete()
    {
        $sql=
            'SELECT '.
                'id,'.
                'form_type,'.
                'enquete '.
            'FROM '.
                DB_PREFIX.'act_enquete '.
            'WHERE '.
                'form_type = '.FORM_TYPE_SELECT.' OR '.
                'form_type = '.FORM_TYPE_CHECKBOX.' OR '.
                'form_type = '.FORM_TYPE_RADIO.' '.
            'ORDER BY '.
                'sort';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        if (empty($result)){
            return ;
        }

        $list = array();
        foreach ($result as $value){
            $value['options'] = $this->get_item($value['id']);
            $list[] = $value;
        }

        $this->Assign('enquetes', $list);
    }

    /**
     * 回答したアンケートの取得
     *
     * @access private
     * @param integer $ref_enquete
     * @param integer $form_type
     * @return array
     */
    function get_item($ref_enquete)
    {        
        $sql=
            'SELECT '.
                'id,'.
                'item '.
            'FROM '.
                DB_PREFIX.'act_item '.
            'WHERE '.
                'ref_enquete = '.$ref_enquete.' '.
            'ORDER BY '.
                'sort';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        if (empty($result)){
            return null;
        }

        $list = array();
        foreach ($result as $row){
            $list[$row['id']] = $row['item'];
        }
        
        return $list;
    }
} // webapp
?>
