<?php
/* ========================================================================
 - [modules/friend/forum/comment.php]
 -      コメントを書き込む
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2007/04/21] if 判定内に&があるためのエラー修正
 -      [2006/08/28] 基礎情報を親クラスから引っ張るように修正
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_manip.php';
require_once WEBAPP_LIB_DIR.'private/frm_pictures.php';
require_once WEBAPP_LIB_DIR.'sql_query.php';
require_once WEBAPP_LIB_DIR.'wap_friend.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_friend
{
    /**
     * コメントID
     * @var integer
     */
    var $id = 0;

    /**
     * トピックID
     * @var integer
     */
    var $ref_topic = 0;

    /**
     * データ操作オブジェクト
     * @var object
     */
    var $objmnp = null;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));

        $this->setTemplateFile('friend/forum/comment.tpl');
        $this->addJavas('common.js');

        /* PathInfo引数の設定 */
        $this->setPathInfo('ref_topic', 1);
        $this->Assign('ref_topic', $this->ref_topic);

        $this->setSafety('id');
        $this->Assign('id', $this->id);
        
        $this->set_topic();
        /* 閲覧権限があるか？ */
        $visibility = $this->visibility & $this->topic['visibility'];
        if (empty($visibility)){
            header('Location: '.HTTP_ACTION.'friend/forum/list/'.$this->ref_friend.'/');
            exit();
        }
        /* 書き込み権限があるか */
        if (!$this->check_condition()){
            header('Location: '.HTTP_ACTION.'friend/forum/browse/'.$this->ref_friend.'/'.$this->ref_topic.'/');
            exit();
        }

        /* アクション処理 */
        if (!empty($_REQUEST['again'])){
            header('Location: '.HTTP_ACTION.'friend/forum/comment/'.$this->ref_friend.'/'.$this->ref_topic.'/again/'.WAP_URI_SEPARATOR.'id='.$this->id);
            exit();
        }

        // 添付画像操作クラスの生成
        $objpic = new frm_pictures($this->id, STATUS_PICTURE_COMMENT);
        $objpic->doUpload();

        // データ操作クラスの生成
        $this->objmnp = new RKT_manip($this->objdb, DB_PREFIX.'frm_comment');
        $result = $this->do_query();
        if ($result == RKT_MANIP_COMPLETE){
            $this->id = $this->objmnp->getCurID();
            
            /* トピックの更新日を最新に */            
            $this->update_topic();

            /* 添付画像処理 */
            $objpic->doDelete(true);
            $objpic->setFix($this->id);
            $objpic->unSetPicture();
            header('Location: '.HTTP_ACTION.'friend/forum/browse/'.$this->ref_friend.'/'.$this->ref_topic.'/');
            exit();
        } elseif ($result == RKT_MANIP_VALIDATED) {
            header('Location: '.HTTP_ACTION.'friend/forum/comment/'.$this->ref_friend.'/'.$this->ref_topic.'/confirm/');
            exit();
        }

        $this->Assign('picture', $objpic->getImgInfos());
        $this->set_picture();
    }

    /**
     * トピック情報の設定
     *
     * @access private
     * @return void
     */
    function set_topic()
    {
        $sql=
            'SELECT '.
                '* '.
            'FROM '.
                DB_PREFIX.'frm_topic '.
            'WHERE '.
                'id = '.$this->ref_topic;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $this->topic = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        $this->Assign('topic', $this->topic);
    }

    /**
     * 書き込み権限があるか？
     *
     * @access private
     * @return boolean
     **/
    function check_condition()
    {
        $sql=
            'SELECT '.
                'ref_prefecture,'.
                'ref_sex,'.
                'ref_blood,'.
                'birthday,'.
                'ref_married,'.
                'ref_hometown '.
            'FROM '.
                DB_PREFIX.'act_profile '.
            'WHERE '.
                'ref_account = '.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        $age = sql_query::getAge($result['birthday']);
        
        if (!empty($this->topic['ref_prefecture'])){
            if ($this->topic['ref_prefecture'] != $result['ref_prefecture']){
                return false;
            }
        }

        if (!empty($this->topic['ref_sex'])){
            if ($this->topic['ref_sex'] != $result['ref_sex']){
                return false;
            }
        }

        if (!empty($this->topic['ref_blood'])){
            if ($this->topic['ref_blood'] != $result['ref_blood']){
                return false;
            }
        }

        if (!empty($this->topic['low_age'])){
            if ($this->topic['low_age'] > $age){
                return false;
            }
        }

        if (!empty($this->topic['high_age'])){
            if ($this->topic['high_age'] < $age){
                return false;
            }
        }

        if (!empty($this->topic['ref_married'])){
            if ($this->topic['ref_married'] != $result['ref_married']){
                return false;
            }
        }

        if (!empty($this->topic['ref_hometown'])){
            if ($this->topic['ref_hometown'] != $result['ref_hometown']){
                return false;
            }
        }
        return true;
    }

    /**
     * 添付画像の設定
     *
     * @access private
     * @return void
     */
    function set_picture()
    {
        $sql=
            'SELECT '.
                'filename as href,'.
                'thumbnail as src,'.
                't_width as width,'.
                't_height as height '.
            'FROM '.
                DB_PREFIX.'frm_picture '.
            'WHERE '.
                'status = '.STATUS_PICTURE_TOPIC.' AND '.
                'ref_relation = '.$this->ref_topic;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $this->Assign('pictures', $result);
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return integer  データ操作結果
     */
    function do_query()
    {
        if (!empty($this->id)){
            $this->objmnp->setCurID($this->id);
        } else {
            $this->objmnp->setValue('regist_date', date('Y-m-d H:i:s'));
        }

        /* 直接入力 */
        $this->objmnp->setValue('modify', date('Y-m-d H:i:s'));
        $this->objmnp->setValue('ref_topic', $this->ref_topic);
        $this->objmnp->setValue('ref_account', $this->account['id']);

        /* 入力フォームからをキャッチ */
        $skip = array(
            'regist_date',
        );
        return $this->objmnp->execute($this,$skip);
    }
    
    /**
     * トピックの更新日を更新
     *
     * @access private
     * @return integer  データ操作結果
     */
    function update_topic()
    {
        $sql = 
            'SELECT '.
                'count(*) as post '.
            'FROM '.
                DB_PREFIX.'frm_comment '.
            'WHERE '.
                'ref_topic = '.$this->ref_topic;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        $post = empty($result['post'])?0:$result['post'];

        $sql =
            'UPDATE '.
                DB_PREFIX.'frm_topic '.
            'SET '.
                "modify='".date('Y-m-d H:i:s')."',".
                'post = '.$post.' '.
            'WHERE '.
                'id = '.$this->ref_topic;
        $this->objdb->exec($sql);
    }
} // webapp
?>
