<?php
/* ========================================================================
 - [mobapp/wap_config.php]
 -      モバイル用各種定義
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/09/21] .htaccess、PathInfoに依存しない処理を追加
 -      [2006/09/12] SMARTY用定数名を変更
 -      [2006/08/22] 作成
 - ======================================================================== */

if (!defined('_WAP_CONFIG_PHP_')){
define('_WAP_CONFIG_PHP_',true);

/* ---------------------------------------- */
/* モバイル用システム情報 */
define('HTTP_ACTION', BASE_URL.'mobile'.WAP_ACTION_STYLE.'/');      // HTTPプロトコル用アクション
define('SSL_ACTION',  SSL_URL.'mobile'.WAP_ACTION_STYLE.'/');       // SSLプロトコル用アクション
define('HTTP_ENTRANCE', HTTP_ACTION.'public/login/entrance/');      // エントランスURL
define('SSL_ENTRANCE', SSL_ACTION.'public/login/entrance/');        // SSL用エントランスURL

/* ---------------------------------------- */
/* モバイル用各種ディレクトリ設定 */
define('WEBAPP_DIR',BASE_DIR.'mobapp'.DIRECTORY_SEPARATOR);         // ウェブアプリケーションパス
define('WEBAPP_LIB_DIR',WEBAPP_DIR.'libs'.DIRECTORY_SEPARATOR);     // ウェブライブラリパス
define('MODULE_DIR',WEBAPP_DIR.'modules'.DIRECTORY_SEPARATOR);      // モジュールパス

/* ---------------------------------------- */
/* Smarty（テンプレートエンジン）の定義部分 */
define('SMARTY_TEMPLATE_DIR', WEBAPP_DIR.'templates'. DIRECTORY_SEPARATOR); // テンプレートパス
define('SMARTY_COMPILE_DIR', COMPILE_DIR.'mobapp'.DIRECTORY_SEPARATOR);     // テンプレート一時コンパイルパス
define('SMARTY_CACHE_DIR', CACHE_DIR.'mobapp'.DIRECTORY_SEPARATOR);         // テンプレート一時コンパイルパス
/* ---------------------------------------- */

/* ---------------------------------------- */
/* RKTフレームワーク用定義 */
define('RKT_INCLUDE_ACCOUNT',WEBAPP_LIB_DIR.'account.php');         // アカウントクラスファイル

/* ---------------------------------------- */
/* 環境設定：セッション */
// ini_set('session.cookie_domain', WAP_COOKIE_DOMAIN);                // クッキードメインの指定
ini_set('session.cookie_lifetime',0);                               // セッションクッキーの寿命
ini_set('session.use_cookies',0);                                   // セッション用クッキーの使用
include_once LIB_DIR.'rkt_session.php';
RKT_session::setSaveHandler();                                      // セッションハンドル設定

/**
 * [アウトプットフィルタ]
 * 文字エンコードの変換
 *
 * 第一引数: string型  $tpl_output
 * 第二引数: Smarty型  $smarty
 * 戻り    :  処理後のアウトプットソース
 */
function tpl_utf2sjis($tpl_output, &$smarty)
{
    return mb_convert_encoding($tpl_output, 'SJIS', 'UTF-8');
}

} // (!defined('_WAP_CONFIG_PHP_'));
?>