<?php
/* ========================================================================
 - [modules/setup/database.php]
 -      データベースの初期設定
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/09/29] モジュール等の読み込み内容を修正
 -      [2006/09/29] プログレスバーの修正
 -      [2006/09/05] 作成
 - ======================================================================== */
 
/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_db.php';
require_once LIB_DIR.'rkt_validate.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp
{
    /**
     * DB接続オジェクト
     * @var object
     */
    var $objdb = null;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        set_time_limit (WAP_TIME_LIMIT);
        $this->objdb = RKT_db::getInstance();

        if (!empty($_GET['complete'])){
            $this->Assign('complete', true);
        }
    }

    /**
     * テンプレートへ変数を設定
     *
     * @access public
     * @param array|string $tpl_var the template variable name(s)
     * @param mixed $value the value to assign
     */
    function Assign($tpl_var,$value)
    {
        $GLOBALS[$tpl_var] = $value;
    }

    /**
     * クリエイトテーブルチェック
     *
     * @access private
     * @return boolean
     */
    function check_create()
    {
        $sqls = array( 
            'mysql'=> "SHOW TABLES LIKE '%rev_review'",
            'pgsql'=> "SELECT relname FROM pg_class WHERE relname LIKE '%rev_review'",
        );
        $stmt = $this->objdb->prepare($sqls[WAP_DB_DRIVER]); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        
        return empty($result);
    }

    /**
     * テーブルインサートチェック
     *
     * @access private
     * @return boolean
     */
    function check_insert()
    {
        $sql = 
            'SELECT '.
                'count(*) as ct '.
            'FROM '.
                DB_PREFIX.'itm_item';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        
        return empty($result['ct']);
    }

    /**
     * メールテンプレートインサートチェック
     *
     * @access private
     * @return boolean
     */
    function check_mailtpl()
    {
        $sql = 
            'SELECT '.
                'count(*) as ct '.
            'FROM '.
                DB_PREFIX.'sys_mailtpl';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        
        return empty($result['ct']);
    }

    /**
     * クリエイトインデックスチェック
     *
     * @access private
     * @return boolean
     */
    function check_index()
    {
        $sqls = array( 
            'mysql'=> "SHOW COLUMNS FROM ".DB_PREFIX."inq_inquire LIKE 'ref_account'",
            'pgsql'=> "SELECT relname Key FROM pg_class WHERE relname LIKE 'sns_inquire_account'",
        );
        $stmt = $this->objdb->prepare($sqls[WAP_DB_DRIVER]); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        
        return empty($result['Key']);
    }

    /**
     * クリエイト文の実行
     *
     * @access public
     * @return integer  データ操作結果
     */
    function doCreate()
    {
        if (!$this->check_create()){
            echo '<script type="text/javascript">setProgress(50,1);</script>'."\r\n";
            return true;
        }
        // blob.sqlはmysql.sql内に梱包
        $filename = WORK_DIR.'sqls'.DIRECTORY_SEPARATOR.WAP_DB_DRIVER.'.sql';
        /* ファイルの中身を取得 */
        $handle = fopen($filename, 'r');
        if (!is_resource($handle)) {
            return false;
        }
        $query = fread($handle, filesize($filename));
        fclose($handle);

        /* クエリを解析し配列に */
        $querys = RKT_db::explodeQuery($query);
        $number = count($querys) + 1;
        $number = 50 / $number;
        $row = 0;

        $oldstep = 0;
        foreach ($querys as $sql){
            $this->objdb->exec($sql);
            $row++;
            $step = intval($row * $number);

            $step = intval($row * $number);
            if ($oldstep != $step){
                flush();
                ob_flush();
                echo '<script type="text/javascript">setProgress('.$step.',1);</script>'."\r\n";
                $oldstep = $step;
            }
        } // foreach ($querys as $query)
        flush();
        ob_flush();
        echo '<script type="text/javascript">setProgress(50,1);</script>'."\r\n";

        return true;
    }

    /**
     * インサート文の実行
     *
     * @access public
     * @return integer  データ操作結果
     */
    function doInsert()
    {
        if (!$this->check_insert()){
            echo '<script type="text/javascript">setProgress(50,2);</script>'."\r\n";
            return true;
        }

        $filename = WORK_DIR.'sqls'.DIRECTORY_SEPARATOR.'insert.sql';
        /* ファイルの中身を取得 */
        $handle = fopen($filename, 'r');
        if (!is_resource($handle)) {
            return false;
        }
        $query = fread($handle, filesize($filename));
        fclose($handle);

        /* クエリを解析し配列に */
        $querys = RKT_db::explodeQuery($query);
        $number = count($querys) + 1;
        $number = 50 / $number;
        $row = 0;


        echo '<script type="text/javascript">oldStep = 1;</script>'."\r\n";
        $oldstep = 0;
        foreach ($querys as $sql){
            $this->objdb->exec($sql);
            $row++;
            $step = intval($row * $number);
            if ($oldstep != $step){
                flush();
                ob_flush();
                echo '<script type="text/javascript">setProgress('.$step.',2);</script>'."\r\n";
                $oldstep = $step;
            }

        } // foreach ($querys as $query)
        flush();
        ob_flush();
        echo '<script type="text/javascript">setProgress(50,2);</script>'."\r\n";

        return true;
    }

    /**
     * インサート文の実行
     *
     * @access public
     * @return integer  データ操作結果
     */
    function doMailtpl()
    {
        if (!$this->check_mailtpl()){
            return true;
        }

        $filename = WORK_DIR.'sqls'.DIRECTORY_SEPARATOR.'mailtpl.sql';
        /* ファイルの中身を取得 */
        $handle = fopen($filename, 'r');
        if (!is_resource($handle)) {
            return false;
        }
        $query = fread($handle, filesize($filename));
        fclose($handle);

        /* クエリを解析し配列に */
        $querys = RKT_db::explodeQuery($query);

        foreach ($querys as $sql){
            $this->objdb->exec($sql);
        } // foreach ($querys as $query)

        return true;
    }

    /**
     * クリエイトインデックス文の実行
     *
     * @access public
     * @return integer  データ操作結果
     */
    function doIndex()
    {
        if (!$this->check_index()){
            echo '<script type="text/javascript">setProgress(50,3);</script>'."\r\n";
            return true;
        }

        $filename = WORK_DIR.'sqls'.DIRECTORY_SEPARATOR.'index.sql';
        /* ファイルの中身を取得 */
        $handle = fopen($filename, 'r');
        if (!is_resource($handle)) {
            return false;
        }
        $query = fread($handle, filesize($filename));
        fclose($handle);

        /* クエリを解析し配列に */
        $querys = RKT_db::explodeQuery($query);
        $number = count($querys) + 1;
        $number = 50 / $number;
        $row = 0;


        echo '<script type="text/javascript">oldStep = 1;</script>'."\r\n";
        foreach ($querys as $sql){
            $this->objdb->exec($sql);
            $row++;
            $step = intval($row * $number);
            flush();
            ob_flush();
            echo '<script type="text/javascript">setProgress('.$step.',3);</script>'."\r\n";

        } // foreach ($querys as $query)
        flush();
        ob_flush();
        echo '<script type="text/javascript">setProgress(50,3);</script>'."\r\n";


        return true;
    }
} // webapp

$webapp = new webapp();
$webapp->execute();
?>
<html lang="ja">
	<head>
		<meta http-equiv="content-type" content='text/html; charset="utf-8"' />
		<title>rktSNSセットアップ</title>
		<link rel="stylesheet" href="./resource/css/common.css" />
		<link rel="stylesheet" href="./resource/css/admin.css" />
        <style media="screen" type="text/css">
        <!--
    	.next {
            font-size:23px;
    		color: blue;
    	}
        DIV.progress	{
        	width: 300px;
        	height: 26px;
        	border: 6px solid #C0C0C0;
        	margin: 0 auto;
        	padding: 0;
        	font-size: 22px;
        	vertical-align: middle;
        }
        DIV.progress DIV.bar {
        	width: 4px;
        	height: 22px;
        	border-top: 2px solid white;
        	border-bottom: 2px solid white;
        	margin: 0;
        	padding: 0;
        	float: left;
        	display: block;
        	background-color: #DDDDDD;
        }
        -->
    	</style>
        <script type="text/javascript">
        <!--
        var oldStep = 1;
        function setProgress(step,id)
        {
            var node = document.getElementById('percent_' + id);
            node.innerHTML = step * 2;
	
        	for (pos=oldStep; pos<=step; pos++) {
                node = document.getElementById('bar_'+ id + '_' + pos);
        		node.style.backgroundImage = 'url(./resource/img/common/progress.gif)';
        	}
        	oldStep = step;
        }

        function setNext()
        {
            var node = document.getElementById('next');
            node.innerHTML = 'ステップ３へ';
        }
        // -->
        </script>
	</head>
	<body>
		<!-- start:ヘッダー -->
		<div id="header">
			<div class="left">
				<a href="./"><img src="./resource/img/header/logo.gif" width="163" height="94" alt="{$smarty.const.WAP_SYSTEM_NAME}" /></a>
			</div>
			<div class="left">
				<div class="search"></div>
			</div>
			<div class="right">
				<div class="sponsor">
					<a href="http://rakuto.net/rktSNS/"><img  src="./resource/img/sponsor/ads.gif" width="468" height="60" alt="広告" /></a>
				</div>
				<div id="headerbar">
				</div>
			</div>
		</div>
		<!-- /finish:ヘッダー -->

		<!-- start:メインコンテンツ -->
		<div id="content">
<!-- start:オペレーション領域 -->
<div id="operation"> 
    <h1>データベースの初期設定</h1>

	<!-- start:丸角 -->
	<div class="round"> 
		<div class="round1"><span></span></div><div class="round2"><span></span></div>
		<div class="round3"></div><div class="round4"></div><div class="round5"></div> 
	</div>
	<div class="round_content">
		<div class="column"><h2>データベースの初期設定</h2></div>
		<!-- start:アクション -->
		<div class="formlist">
			<form name="edit" method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>">
                <input type="hidden" name="page" value="admin" />
				<div class="formrow"><strong>作業レベル</strong></div>
				<div class="formrow">
					<label class="column">テーブルの作成：</label>
					<div>
        				<div class="progress" style="width:300px">
        					<div id="bar_1_1" class="bar" style="border-left: 2px solid white;"></div><div id="bar_1_2" class="bar"></div>
        					<div id="bar_1_3" class="bar"></div><div id="bar_1_4" class="bar"></div>
        					<div id="bar_1_5" class="bar"></div><div id="bar_1_6" class="bar" style="border-left: 2px solid white;"></div>
        					<div id="bar_1_7" class="bar"></div><div id="bar_1_8" class="bar"></div>
        					<div id="bar_1_9" class="bar"></div><div id="bar_1_10" class="bar"></div>

        					<div id="bar_1_11" class="bar" style="border-left: 2px solid white;"></div><div id="bar_1_12" class="bar"></div>
        					<div id="bar_1_13" class="bar"></div><div id="bar_1_14" class="bar"></div>
        					<div id="bar_1_15" class="bar"></div><div id="bar_1_16" class="bar" style="border-left: 2px solid white;"></div>
        					<div id="bar_1_17" class="bar"></div><div id="bar_1_18" class="bar"></div>
        					<div id="bar_1_19" class="bar"></div><div id="bar_1_20" class="bar"></div>

        					<div id="bar_1_21" class="bar" style="border-left: 2px solid white;"></div><div id="bar_1_22" class="bar"></div>
        					<div id="bar_1_23" class="bar"></div><div id="bar_1_24" class="bar"></div>
        					<div id="bar_1_25" class="bar"></div><div id="bar_1_26" class="bar" style="border-left: 2px solid white;"></div>
        					<div id="bar_1_27" class="bar"></div><div id="bar_1_28" class="bar"></div>
        					<div id="bar_1_29" class="bar"></div><div id="bar_1_30" class="bar"></div>

        					<div id="bar_1_31" class="bar" style="border-left: 2px solid white;"></div><div id="bar_1_32" class="bar"></div>
        					<div id="bar_1_33" class="bar"></div><div id="bar_1_34" class="bar"></div>
        					<div id="bar_1_35" class="bar"></div><div id="bar_1_36" class="bar" style="border-left: 2px solid white;"></div>
        					<div id="bar_1_37" class="bar"></div><div id="bar_1_38" class="bar"></div>
        					<div id="bar_1_39" class="bar"></div><div id="bar_1_40" class="bar"></div>

        					<div id="bar_1_41" class="bar" style="border-left: 2px solid white;"></div><div id="bar_1_42" class="bar"></div>
        					<div id="bar_1_43" class="bar"></div><div id="bar_1_44" class="bar"></div>
        					<div id="bar_1_45" class="bar"></div><div id="bar_1_46" class="bar" style="border-left: 2px solid white;"></div>
        					<div id="bar_1_47" class="bar"></div><div id="bar_1_48" class="bar"></div>
        					<div id="bar_1_49" class="bar"></div><div id="bar_1_50" class="bar"></div>
					
                        	：<span id="percent_1"></span>％
        				</div>
                    </div>
				</div>
				<div class="formrow">
					<label class="column">データの生成：</label>
					<div>
        				<div class="progress" style="width:300px">
        					<div id="bar_2_1" class="bar" style="border-left: 2px solid white;"></div><div id="bar_2_2" class="bar"></div>
        					<div id="bar_2_3" class="bar"></div><div id="bar_2_4" class="bar"></div>
        					<div id="bar_2_5" class="bar"></div><div id="bar_2_6" class="bar" style="border-left: 2px solid white;"></div>
        					<div id="bar_2_7" class="bar"></div><div id="bar_2_8" class="bar"></div>
        					<div id="bar_2_9" class="bar"></div><div id="bar_2_10" class="bar"></div>

        					<div id="bar_2_11" class="bar" style="border-left: 2px solid white;"></div><div id="bar_2_12" class="bar"></div>
        					<div id="bar_2_13" class="bar"></div><div id="bar_2_14" class="bar"></div>
        					<div id="bar_2_15" class="bar"></div><div id="bar_2_16" class="bar" style="border-left: 2px solid white;"></div>
        					<div id="bar_2_17" class="bar"></div><div id="bar_2_18" class="bar"></div>
        					<div id="bar_2_19" class="bar"></div><div id="bar_2_20" class="bar"></div>

        					<div id="bar_2_21" class="bar" style="border-left: 2px solid white;"></div><div id="bar_2_22" class="bar"></div>
        					<div id="bar_2_23" class="bar"></div><div id="bar_2_24" class="bar"></div>
        					<div id="bar_2_25" class="bar"></div><div id="bar_2_26" class="bar" style="border-left: 2px solid white;"></div>
        					<div id="bar_2_27" class="bar"></div><div id="bar_2_28" class="bar"></div>
        					<div id="bar_2_29" class="bar"></div><div id="bar_2_30" class="bar"></div>

        					<div id="bar_2_31" class="bar" style="border-left: 2px solid white;"></div><div id="bar_2_32" class="bar"></div>
        					<div id="bar_2_33" class="bar"></div><div id="bar_2_34" class="bar"></div>
        					<div id="bar_2_35" class="bar"></div><div id="bar_2_36" class="bar" style="border-left: 2px solid white;"></div>
        					<div id="bar_2_37" class="bar"></div><div id="bar_2_38" class="bar"></div>
        					<div id="bar_2_39" class="bar"></div><div id="bar_2_40" class="bar"></div>

        					<div id="bar_2_41" class="bar" style="border-left: 2px solid white;"></div><div id="bar_2_42" class="bar"></div>
        					<div id="bar_2_43" class="bar"></div><div id="bar_2_44" class="bar"></div>
        					<div id="bar_2_45" class="bar"></div><div id="bar_2_46" class="bar" style="border-left: 2px solid white;"></div>
        					<div id="bar_2_47" class="bar"></div><div id="bar_2_48" class="bar"></div>
        					<div id="bar_2_49" class="bar"></div><div id="bar_2_50" class="bar"></div>
					
                        	：<span id="percent_2"></span>％
        				</div>
                    </div>
				</div>
				<div class="formrow">
					<label class="column">インデックスの生成：</label>
					<div>
        				<div class="progress" style="width:300px">
        					<div id="bar_3_1" class="bar" style="border-left: 2px solid white;"></div><div id="bar_3_2" class="bar"></div>
        					<div id="bar_3_3" class="bar"></div><div id="bar_3_4" class="bar"></div>
        					<div id="bar_3_5" class="bar"></div><div id="bar_3_6" class="bar" style="border-left: 2px solid white;"></div>
        					<div id="bar_3_7" class="bar"></div><div id="bar_3_8" class="bar"></div>
        					<div id="bar_3_9" class="bar"></div><div id="bar_3_10" class="bar"></div>

        					<div id="bar_3_11" class="bar" style="border-left: 2px solid white;"></div><div id="bar_3_12" class="bar"></div>
        					<div id="bar_3_13" class="bar"></div><div id="bar_3_14" class="bar"></div>
        					<div id="bar_3_15" class="bar"></div><div id="bar_3_16" class="bar" style="border-left: 2px solid white;"></div>
        					<div id="bar_3_17" class="bar"></div><div id="bar_3_18" class="bar"></div>
        					<div id="bar_3_19" class="bar"></div><div id="bar_3_20" class="bar"></div>

        					<div id="bar_3_21" class="bar" style="border-left: 2px solid white;"></div><div id="bar_3_22" class="bar"></div>
        					<div id="bar_3_23" class="bar"></div><div id="bar_3_24" class="bar"></div>
        					<div id="bar_3_25" class="bar"></div><div id="bar_3_26" class="bar" style="border-left: 2px solid white;"></div>
        					<div id="bar_3_27" class="bar"></div><div id="bar_3_28" class="bar"></div>
        					<div id="bar_3_29" class="bar"></div><div id="bar_3_30" class="bar"></div>

        					<div id="bar_3_31" class="bar" style="border-left: 2px solid white;"></div><div id="bar_3_32" class="bar"></div>
        					<div id="bar_3_33" class="bar"></div><div id="bar_3_34" class="bar"></div>
        					<div id="bar_3_35" class="bar"></div><div id="bar_3_36" class="bar" style="border-left: 2px solid white;"></div>
        					<div id="bar_3_37" class="bar"></div><div id="bar_3_38" class="bar"></div>
        					<div id="bar_3_39" class="bar"></div><div id="bar_3_40" class="bar"></div>

        					<div id="bar_3_41" class="bar" style="border-left: 2px solid white;"></div><div id="bar_3_42" class="bar"></div>
        					<div id="bar_3_43" class="bar"></div><div id="bar_3_44" class="bar"></div>
        					<div id="bar_3_45" class="bar"></div><div id="bar_3_46" class="bar" style="border-left: 2px solid white;"></div>
        					<div id="bar_3_47" class="bar"></div><div id="bar_3_48" class="bar"></div>
        					<div id="bar_3_49" class="bar"></div><div id="bar_3_50" class="bar"></div>
					
                        	：<span id="percent_3"></span>％
        				</div>
                    </div>
				</div>


				<div class="formbutton">
                    <a href="<?php echo $_SERVER['PHP_SELF']; ?>?page=admin"><strong id="next" class="next"></strong></a>
				</div>
			</form>

		</div>
		<!-- /finish:アクション -->
	</div>
	<div class="round"> 
		<div class="round5"></div><div class="round4"></div><div class="round3"></div> 
		<div class="round2"><span></span></div><div class="round1"><span></span></div>
	</div>
	<!-- /finish:丸角 -->

</div>
<!-- /finish:オペレーション領域 -->
<br />

		</div>
		<!-- /finish:メインコンテンツ -->

		<!-- start:フッター -->
		<div id="footer"></div>
		<!-- /finish:フッター -->
<?php
$webapp->doCreate();
$webapp->doInsert();
$webapp->doMailtpl();
$webapp->doIndex();
?>
<script type="text/javascript">setNext();</script>
	</body>
</html>