<?php
/* ========================================================================
 - [modules/private/forum/response.php]
 -      返事を書く
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_manip.php';
require_once WEBAPP_LIB_DIR.'wap_private.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_private
{
    /**
     * お返事ID
     * @var integer
     */
    var $id = 0;

    /**
     * コメントID
     * @var integer
     */
    var $ref_comment = 0;

    /**
     * トピックID
     * @var integer
     */
    var $ref_topic = 0;

    /**
     * データ操作オブジェクト
     * @var object
     */
    var $objmnp = null;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));

        $this->setTemplateFile('private/forum/response.tpl');
        $this->addJavas('common.js');

        /* PathInfo引数の設定 */
        $this->setPathInfo('ref_topic');
        $this->Assign('ref_topic', $this->ref_topic);

        $this->setSafety('ref_comment');
        $this->Assign('ref_comment', $this->ref_comment);
        $this->set_curid();
        
        if (!$this->is_response()){
            header('Location: '.HTTP_ACTION.'private/forum/browse/'.$this->ref_topic.'/');
            exit();            
        }

        /* アクション処理 */
        if (!empty($_REQUEST['again'])){
            header('Location: '.HTTP_ACTION.'private/forum/response/'.$this->ref_topic.'/again/'.WAP_URI_SEPARATOR.'ref_comment='.$this->ref_comment);
            exit();
        }

        // データ操作クラスの生成
        $this->objmnp = new RKT_manip($this->objdb, DB_PREFIX.'frm_response');
        $result = $this->do_query();
        if ($result == RKT_MANIP_COMPLETE){
            $this->id = $this->objmnp->getCurID();
            
            /* トピックの更新日を最新に */            
            $this->update_topic();

            header('Location: '.HTTP_ACTION.'private/forum/browse/'.$this->ref_topic.'/');
            exit();
        } elseif ($result == RKT_MANIP_VALIDATED) {
            header('Location: '.HTTP_ACTION.'private/forum/response/'.$this->ref_topic.'/confirm/'.WAP_URI_SEPARATOR.'ref_comment='.$this->ref_comment);
            exit();
        }

        $this->set_point();
        $this->set_info();
    }

    /**
     * 返信権限があるか
     *
     * @access private
     * @return boolean 正常時：真
     */
    function is_response()
    {
        $sql=
            'SELECT '.
                'count(id) as ct '.
            'FROM '.
                DB_PREFIX.'frm_comment '.
            'WHERE '.
                'id = '.$this->ref_comment.' AND '.
                'ref_account = '.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        return empty($result['ct']);
    }

    /**
     * 評価ポイントの設定
     *
     * @access private
     * @return void
     */
    function set_point()
    {
        $sql=
            'SELECT '.
                'point,'.
                'label '.
            'FROM '.
                DB_PREFIX.'rev_point '.
            'ORDER BY '.
                'sort';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $list = array();
        foreach ($result as $value){
            $list[$value['point']] = $value['label'];
        }
        
        $this->Assign('points', $list);
    }

    /**
     * カレントIDの取得
     *
     * @access private
     * @return void
     */
    function set_curid()
    {
        $sql=
            'SELECT '.
                'id '.
            'FROM '.
                DB_PREFIX.'frm_response '.
            'WHERE '.
                'ref_comment = '.$this->ref_comment.' AND '.
                'ref_account = '.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        $this->id = empty($result['id'])?0:$result['id'];
    }

    /**
     * 情報の設定
     *
     * @access private
     * @return void
     */
    function set_info()
    {
        $sql=
            'SELECT '.
                'cmm.ref_account as ref_account,'.
                'pro.nickname as nickname,'.
                'act.friend_number as friend_number,'.
                'pht.thumbnail as src,'.
                'pht.t_width as width,'.
                'pht.t_height as height,'.
                'tpc.topic as topic,'.
                'cmm.comment as comment '.
            'FROM '.
                DB_PREFIX.'act_account act '.
                    'LEFT JOIN '.DB_PREFIX.'act_photo pht '.
                    'ON act.id = pht.ref_account AND '.
                        'pht.status = '.STATUS_PHOTO_MAIN.','.
                DB_PREFIX.'act_profile pro,'.
                DB_PREFIX.'frm_topic tpc,'.
                DB_PREFIX.'frm_comment cmm '.
            'WHERE '.
                'act.id = pro.ref_account AND '.
                'act.id = cmm.ref_account AND '.
                'tpc.id = cmm.ref_topic AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'cmm.id = '.$this->ref_comment;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        $this->Assign('info', $result);
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return integer  データ操作結果
     */
    function do_query()
    {
        if (!empty($this->id)){
            $this->objmnp->setCurID($this->id);
        } else {
            $this->objmnp->setValue('regist_date', date('Y-m-d H:i:s'));
        }

        /* 直接入力 */
        $this->objmnp->setValue('modify', date('Y-m-d H:i:s'));
        $this->objmnp->setValue('ref_topic', $this->ref_topic);
        $this->objmnp->setValue('ref_comment', $this->ref_comment);
        $this->objmnp->setValue('ref_account', $this->account['id']);

        /* 入力フォームからをキャッチ */
        $skip = array(
            'regist_date',
        );
        return $this->objmnp->execute($this,$skip);
    }
    
    /**
     * トピックの更新日を更新
     *
     * @access private
     * @return boolean  真偽値
     */
    function update_topic()
    {
        $sql =
            'UPDATE '.
                DB_PREFIX.'frm_topic '.
            'SET '.
                "modify = '".date('Y-m-d H:i:s')."' ".
            'WHERE '.
                'id ='.$this->ref_topic;
        return $this->objdb->exec($sql);
    }
} // webapp
?>
