<?php
/* ========================================================================
 - [modules/friend/show/profile.php]
 -      プロフィール
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2007/02/03] 市区町村条件指定エラーの修正
 -      [2006/08/29] 表示整形の不具合修正
 -      [2006/08/27] 基礎情報を親クラスから引っ張るように修正
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once WEBAPP_LIB_DIR.'sql_query.php';
require_once WEBAPP_LIB_DIR.'wap_friend.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_friend
{
    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));

        $this->setTemplateFile('friend/show/profile.tpl');

        $this->set_relation();

        $this->set_my_nickname();
        $this->set_profile();
        $this->set_enquete();
        $this->set_friend();
        $this->set_community();
        $this->set_community_number();
        $this->set_diary();
        $this->set_review();
        $this->set_forum();
        $this->set_intro();
        
        $this->doFootprint();
    }

    /**
     * 友達のつながり取得
     *
     * @access private
     * @return array
     */
    function set_my_nickname()
    {
        $sql=
            'SELECT '.
                'nickname '.
            'FROM '.
                DB_PREFIX.'act_profile pro '.
            'WHERE '.
                'ref_account = '.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        $this->Assign('my_nickname', $result['nickname']);
    }

    /**
     * 友達のつながり設定
     *
     * @access private
     * @return void
     */
    function set_relation()
    {
        $relation = array();
        
        if ($this->isFriend()){
            $relation[] = array(
                'id'=>      $this->ref_friend,
                'nickname'=>$this->friend['nickname'],
            );
            $this->Assign('relations', $relation);
            return ;
        } else {
            $joint = $this->get_relation();
            if (is_array($joint)){
                $relation[] = $joint;
                $relation[] = array(
                    'id'=>      $this->ref_friend,
                    'nickname'=>$this->friend['nickname'],
                );
            }
        } // if ($this->isFriend())
        
        if (!count($relation)){
            $relation = false;
        }

        $this->Assign('relations', $relation);
    }

    /**
     * 友達のつながり取得
     *
     * @access private
     * @return array
     */
    function get_relation()
    {
        $sql=
            'SELECT '.
                'pro.nickname as nickname,'.
                'direct.ref_friend as friend '.
            'FROM '.
                DB_PREFIX.'act_profile pro,'.
                DB_PREFIX.'fri_friends direct,'.
                DB_PREFIX.'fri_friends near '.
            'WHERE '.
                'pro.ref_account = direct.ref_friend AND '.
                'direct.ref_friend = near.ref_account AND '.
                'direct.avail = '.AVAIL_ENABLE.' AND '.
                'direct.status = '.STATUS_FRIEND_CONNECT.' AND '.
                'direct.ref_account = '.$this->account['id'].' AND '.
                'near.avail = '.AVAIL_ENABLE.' AND '.
                'near.status = '.STATUS_FRIEND_CONNECT.' AND '.
                'near.ref_friend = '.$this->ref_friend;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        if (empty($result)){
            return false;
        }
        return $result;
    }

    /**
     * フラグの設定
     *
     * @access private
     * @return void
     */
    function set_flag(&$value)
    {
        $is_friend = $this->isFriend();
        $flag = array();

        $flag = ($value['name_flag'] == VISIBILITY_FRIEND)?$is_friend:true;
        $flag = ($value['name_flag'] == VISIBILITY_HIDDEN)?false:$flag;
        $value['name_flag'] = $flag;

        $flag = ($value['prefecture_flag'] == VISIBILITY_FRIEND)?$is_friend:true;
        $flag = ($value['prefecture_flag'] == VISIBILITY_HIDDEN)?false:$flag;
        $value['prefecture_flag'] = $flag;

        $flag = ($value['blood_flag'] == VISIBILITY_FRIEND)?$is_friend:true;
        $flag = ($value['blood_flag'] == VISIBILITY_HIDDEN)?false:$flag;
        $value['blood_flag'] = $flag;

        $flag = ($value['birthday_flag'] == VISIBILITY_FRIEND)?$is_friend:true;
        $flag = ($value['birthday_flag'] == VISIBILITY_HIDDEN)?false:$flag;
        $value['birthday_flag'] = $flag;

        $flag = ($value['age_flag'] == VISIBILITY_FRIEND)?$is_friend:true;
        $flag = ($value['age_flag'] == VISIBILITY_HIDDEN)?false:$flag;
        $value['age_flag'] = $flag;

        $flag = ($value['married_flag'] == VISIBILITY_FRIEND)?$is_friend:true;
        $flag = ($value['married_flag'] == VISIBILITY_HIDDEN)?false:$flag;
        $value['married_flag'] = $flag;

        $flag = ($value['hometown_flag'] == VISIBILITY_FRIEND)?$is_friend:true;
        $flag = ($value['hometown_flag'] == VISIBILITY_HIDDEN)?false:$flag;
        $value['hometown_flag'] = $flag;

        $flag = ($value['sex_flag'] == VISIBILITY_FRIEND)?$is_friend:true;
        $flag = ($value['sex_flag'] == VISIBILITY_HIDDEN)?false:$flag;
        $value['sex_flag'] = $flag;
    }

    /**
     * プロフィールの設定
     *
     * @access private
     * @return void
     */
    function set_profile()
    {
        $sql=
            'SELECT '.
                'pro.id as id,'.
                'pro.ref_account as ref_account,'.
                'pro.modify as modify,'.
                'pro.first_name as first_name,'.
                'pro.second_name as second_name,'.
                'pro.name_flag as name_flag,'.
                'pro.nickname as nickname,'.
                'pro.prefecture_flag as prefecture_flag,'.
                'pro.ref_blood as ref_blood,'.
                'pro.blood_flag as blood_flag,'.
                'pro.birthday as birthday,'.
                'pro.birthday_flag as birthday_flag,'.
                'pro.age_flag as age_flag,'.
                'pro.married_flag as married_flag,'.
                'pro.hometown_flag as hometown_flag,'.
                'pro.publicity as publicity,'.
                'prf.prefecture as prefecture,'.
                'lcl.local as local,'.
                'sex.sex as sex,'.
                'pro.sex_flag as sex_flag,'.
                'bld.blood as blood,'.
                'mrd.married as married,'.
                'htn.prefecture as hometown,'.
                'hlc.local as homelocal '.
            'FROM '.
                DB_PREFIX.'act_profile pro '.
                    'LEFT JOIN '.DB_PREFIX.'act_blood bld '.
                    'ON bld.id = pro.ref_blood '.
                    'LEFT JOIN '.DB_PREFIX.'ara_prefecture prf '.
                    'ON prf.id = pro.ref_prefecture '.
                    'LEFT JOIN '.DB_PREFIX.'ara_local lcl '.
                    'ON lcl.id = pro.ref_local '.
                    'LEFT JOIN '.DB_PREFIX.'ara_prefecture htn '.
                    'ON htn.id = pro.ref_hometown '.
                    'LEFT JOIN '.DB_PREFIX.'ara_local hlc '.
                    'ON hlc.id = pro.ref_homelocal,'.
                DB_PREFIX.'act_account act,'.
                DB_PREFIX.'act_sex sex,'.
                DB_PREFIX.'act_married mrd '.
            'WHERE '.
                'act.id = pro.ref_account AND '.
                'sex.id = pro.ref_sex AND '.
                'mrd.id = pro.ref_married AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'pro.ref_account = '.$this->ref_friend;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        if (empty($result)){
            header('Location: '.HTTP_ACTION);
            exit();
        }
        
        $this->set_flag($result);

        $this->Assign('profile',$result);
    }

    /**
     * アンケートの設定
     *
     * @access private
     * @return void
     */
    function set_enquete()
    {
        $sql=
            'SELECT '.
                'id,'.
                'form_type,'.
                'enquete '.
            'FROM '.
                DB_PREFIX.'act_enquete '.
            'ORDER BY '.
                'sort';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        if (empty($result)){
            return ;
        }

        $list = array();
        foreach ($result as $value){
            if ($value['form_type'] == FORM_TYPE_CHECKBOX){
                $value['value'] = $this->get_select($value['id']);
            } else {
                $value['value'] = $this->get_item($value['id'],$value['form_type']);
            }
            $list[] = $value;
        }

        $this->Assign('enquetes', $list);
    }

    /**
     * 回答したアンケートの取得
     *
     * @access private
     * @param integer $ref_enquete
     * @param integer $form_type
     * @return array
     */
    function get_item($ref_enquete, $form_type)
    {
        /* 友達か？ */
        $where = '';
        if ($this->isFriend()){
            $where = ' OR con.visibility = '.VISIBILITY_FRIEND;
        }
        $sql=
            'SELECT '.
                'con.ref_enquete as ref_enquete,'.
                'itm.item as item,'.
                'con.content as content '.
            'FROM '.
                DB_PREFIX.'act_content con '.
                    'LEFT JOIN '.DB_PREFIX.'act_item itm '.
                    'ON itm.id = con.ref_item '.
            'WHERE '.
                '(con.visibility = '.VISIBILITY_PUBLIC.' OR '.
                 'con.visibility = '.VISIBILITY_PROTECTED.
                $where.') AND '.
                'con.ref_enquete = '.$ref_enquete.' AND '.
                'con.ref_account = '.$this->ref_friend;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        if (empty($result)){
            return null;
        }

        if ($form_type == FORM_TYPE_SELECT || $form_type == FORM_TYPE_RADIO){
            return $result['item'];
        }
        
        return $result['content'];
    }

    /**
     * 選択肢の取得
     *
     * @access private
     * @param integer $ref_enquete
     * @return string
     */
    function get_select($ref_enquete)
    {
        /* 友達か？ */
        $where = '';
        if ($this->isFriend()){
            $where = ' OR sel.visibility = '.VISIBILITY_FRIEND;
        }
        $sql=
            'SELECT '.
                'itm.item as item '.
            'FROM '.
                DB_PREFIX.'act_item itm,'.
                DB_PREFIX.'act_select sel '.
            'WHERE '.
                'itm.id = sel.ref_item AND '.
                'sel.ref_enquete = '.$ref_enquete.' AND '.
                '(sel.visibility = '.VISIBILITY_PUBLIC.' OR '.
                 'sel.visibility = '.VISIBILITY_PROTECTED.
                $where.') AND '.
                'sel.ref_account = '.$this->ref_friend;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        if (empty($result)){
            return ;
        }
        $list = array();
        foreach ($result as $row){
            $list[] = $row['item'];
        }
        
        return  implode(',&nbsp;',$list);
    }

    /**
     * 情報の成形
     *
     * @access private
     * @return array
     */
    function shape_list($values)
    {
        $list = array();
        $row = 0;
        $column = 0;
        foreach ($values as $value){
            // 改行処理
            if ($column >= 3){
                $column = 0;
                $row++;
            }
            $list[$row][$column] = $value;
            $column++;
        } // foreach ($result as $value)
        
        return $list;
    }

    /**
     * 友達の設定
     *
     * @access private
     * @return void
     */
    function set_friend()
    {
        $sql=
            'SELECT '.
                'act.id as id,'.
                'pro.nickname as nickname,'.
                'act.friend_number as friend_number,'.
                'pht.thumbnail as src,'.
                'pht.t_width as width,'.
                'pht.t_height as height '.
            'FROM '.
                DB_PREFIX.'act_account act '.
                    'LEFT JOIN '.DB_PREFIX.'act_photo pht '.
                    'ON act.id = pht.ref_account AND '.
                        'pht.status = '.STATUS_PHOTO_MAIN.','.
                DB_PREFIX.'act_profile pro,'.
                DB_PREFIX.'fri_friends fri '.
            'WHERE '.
                'act.id = fri.ref_friend AND '.
                'act.id = pro.ref_account AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'fri.avail = '.AVAIL_ENABLE.' AND '.
                'fri.status = '.STATUS_FRIEND_CONNECT.' AND '.
                'fri.ref_account = '.$this->ref_friend.' '.
            'ORDER BY '.
                'act.last_login DESC '.
            'LIMIT 9';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        
        $row = count($result);
        $inits = array (0,2,1);
        for ($row=$inits[$row%3]; $row; $row--){
            $result[] = array(
                'name'=> '',
                'friend_number'=>0,
                'subject'=> '',
                'src'=>    '',
                'width'=>  0,
                'height'=> 0
            );
        }
        $this->Assign('friends', $this->shape_list($result));
    }

    /**
     * コミュニティの設定
     *
     * @access private
     * @return void
     */
    function set_community()
    {
        $sql=
            'SELECT '.
                'com.id as id,'.
                'com.community as community,'.
                'pic.thumbnail as src,'.
                'pic.t_width as width,'.
                'pic.t_height as height '.
            'FROM '.
                DB_PREFIX.'com_community com '.
                    'LEFT JOIN '.DB_PREFIX.'com_picture pic '.
                    'ON com.id = pic.ref_community AND '.
                       'pic.status = '.STATUS_PICTURE_COMMUNITY.','.
                DB_PREFIX.'com_names nms '.
            'WHERE '.
                'com.id = nms.ref_community AND '.
                'com.avail = '.AVAIL_ENABLE.' AND '.
                '(nms.status = '.STATUS_COMMUNITY_MEMBER.' OR '.
                 'nms.status = '.STATUS_COMMUNITY_CHANGE.' OR '.
                 'nms.status = '.STATUS_COMMUNITY_ADMIN.') AND '.
                'nms.ref_account = '.$this->ref_friend.' '.
            'ORDER BY '.
                'nms.modify '.
            'LIMIT 9';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        if (empty($result)){
            $this->Assign('communitys', null);
            return ;
        }

        $list = array();
        $row=0;
        foreach ($result as $value){
            $value['src'] = empty($value['src'])?BASE_URL.NOPHOTO_SMALL:BASE_URL.$value['src'];
            $value['width'] = empty($value['width'])?PHOTO_SMALL_SIZE:$value['width'];
            $value['height'] = empty($value['height'])?PHOTO_SMALL_SIZE:$value['height'];

            $list[] = array(
                'id'=> $value['id'],
                'community'=> $value['community'],
                'src'=> $value['src'],
                'width'=> $value['width'],
                'height'=> $value['height'],
            );
            $row++;
        }

        $inits = array (0,2,1);
        for ($row=$inits[$row%3]; $row; $row--){
            $list[] = array(
                'id'=> '',
                'community'=> '',
                'src'=>    '',
                'width'=>  0,
                'height'=> 0
            );
        }

        $this->Assign('communitys', $this->shape_list($list));
    }

    /**
     * コミュニティ数の設定
     *
     * @access private
     * @return void
     */
    function set_community_number()
    {
        $sql=
            'SELECT '.
                'count(id) as ct '.
            'FROM '.
                DB_PREFIX.'com_names '.
            'WHERE '.
                'ref_account = '.$this->ref_friend. ' AND '.
                '(status = '.STATUS_COMMUNITY_MEMBER.' OR '.
                 'status = '.STATUS_COMMUNITY_CHANGE.' OR '.
                 'status = '.STATUS_COMMUNITY_ADMIN.')';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        $this->Assign('community_num',$result['ct']);
    }

    /**
     * 日記の設定
     *
     * @access private
     * @return void
     */
    function set_diary()
    {
        $sql=
            'SELECT '.
                'ent.id as ref_entry,'.
                'act.id as ref_friend,'.
                'pro.nickname as nickname,'.
                'ent.regist_date as modify,'.
                'ent.subject as subject '.
            'FROM '.
                DB_PREFIX.'act_account act,'.
                DB_PREFIX.'act_profile pro,'.
                DB_PREFIX.'dia_diary dia,'.
                DB_PREFIX.'dia_entry ent '.
            'WHERE '.
                'act.id = pro.ref_account AND '.
                'act.id = dia.ref_account AND '.
                'dia.id = ent.ref_diary AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'dia.ref_account = '.$this->ref_friend.' '.
            'ORDER BY '.
                'ent.regist_date DESC '.
            'LIMIT 5';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $this->Assign('diarys', $result);
    }

    /**
     * レビューの設定
     *
     * @access private
     * @return void
     */
    function set_review()
    {
        $sql = 
            'SELECT '.
                'itm.id as id,'.
                'itm.name as name,'.
                'rev.modify as modify '.
            'FROM '.
                DB_PREFIX.'rev_item itm,'.
                DB_PREFIX.'rev_review rev '.
            'WHERE '.
                'itm.id = rev.ref_item AND '.
                'rev.ref_account = '.$this->ref_friend.' '.
            'ORDER BY '.
                'rev.modify DESC '.
            'LIMIT 5';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $this->Assign('reviews', $result);
    }

    /**
     * Myフォーラムの新トピック
     *
     * @access private
     * @return void
     */
    function set_forum()
    {
        /* 友達か？ */
        $where = '';
        if ($this->isFriend()){
            $where = 'OR visibility = '.VISIBILITY_FRIEND.' ';
        }

        $sql=
            'SELECT '.
                'id,'.
                'modify,'.
                'post,'.
                'topic '.
            'FROM '.
                DB_PREFIX.'frm_topic '.
            'WHERE '.
                'ref_account = '.$this->ref_friend.' AND '.
                '(visibility = '.VISIBILITY_PROTECTED.' '.
                $where.') '.
            'ORDER BY '.
                'modify DESC '.
            'LIMIT 5';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $this->Assign('forums', $result);
    }

    /**
     * 紹介文の設定
     *
     * @access private
     * @return void
     */
    function set_intro()
    {
        $sql=
            'SELECT '.
                'act.id as id,'.
                'pro.nickname as nickname,'.
                'itr.ref_friend as ref_friend,'.
                'itr.relation as relation,'.
                'itr.comment as comment,'.
                'pht.thumbnail as src,'.
                'pht.t_width as width,'.
                'pht.t_height as height '.
            'FROM '.
                DB_PREFIX.'act_account act '.
                    'LEFT JOIN '.DB_PREFIX.'act_photo pht '.
                    'ON act.id = pht.ref_account AND '.
                        'pht.status = '.STATUS_PHOTO_MAIN.','.
                DB_PREFIX.'act_profile pro,'.
                DB_PREFIX.'fri_intro itr '.
            'WHERE '.
                'act.id = pro.ref_account AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'act.id = itr.ref_friend AND '.
                'itr.ref_account = '.$this->ref_friend.' '.
            'ORDER BY '.
                'itr.modify '.
            'LIMIT 5';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        
        $this->Assign('intros', $result);
    }
} // webapp
?>
