<?php
/* ========================================================================
 - [modules/friend/show/community.php]
 -      コミュニティ一覧
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/08/31] 表示整形の不具合修正
 -      [2006/08/27] 基礎情報を親クラスから引っ張るように修正
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_pager.php';
require_once WEBAPP_LIB_DIR.'wap_friend.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_friend
{
    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));

        $this->setTemplateFile('friend/show/community.tpl');

        $this->set_community();
    }

    /**
     * グループの設定
     *
     * @access private
     * @return void
     */
    function set_community()
    {
        $offset = RKT_validate::getSafety('number', 'offset');
        $_SESSION['offset'] = $offset;

        $objpgr = new RKT_pager($this->objdb, $offset, LIMIT_TILE);    // クラスの生成
        $sql=
            'SELECT '.
                'com.id as id,'.
                'com.community as community,'.
                'com.total as total,'.
                'com.ref_account as ref_account,'.
                'pic.thumbnail as src,'.
                'pic.t_width as width,'.
                'pic.t_height as height '.
            'FROM '.
                DB_PREFIX.'com_community com '.
                    'LEFT JOIN '.DB_PREFIX.'com_picture pic '.
                    'ON com.id = pic.ref_community AND '.
                       'pic.status = '.STATUS_PICTURE_COMMUNITY.','.
                DB_PREFIX.'com_names nms '.
            'WHERE '.
                'com.id = nms.ref_community AND '.
                'com.avail = '.AVAIL_ENABLE.' AND '.
                '(nms.status = '.STATUS_COMMUNITY_MEMBER.' OR '.
                 'nms.status = '.STATUS_COMMUNITY_CHANGE.' OR '.
                 'nms.status = '.STATUS_COMMUNITY_ADMIN.') AND '.
                 'nms.ref_account = '.$this->ref_friend.' '.
            'ORDER BY '.
                'nms.modify ';
        $objpgr->setSql($sql);

        $page = array(
            'infos'=> $objpgr->getInfo(),
            'links'=> $objpgr->getPager()
        );
        $this->Assign('page', $page);

        $result = $objpgr->getValues();
        if (empty($result)){
            return ;
        }
        
        $list = array();
        $row=0;
        foreach ($result as $value){
            $value['src'] = empty($value['src'])?BASE_URL.NOPHOTO_SMALL:BASE_URL.$value['src'];
            $list[] = $value;
            $row++;
        }
        
        $inits = array (0,4,3,2,1);
        for ($row=$inits[$row%5]; $row; $row--){
            $list[] = array(
                'community'=>  '',
                'total'=>  0,
                'src'=>    BASE_URL.NOPHOTO_SMALL,
                'width'=>  PHOTO_SMALL_SIZE,
                'height'=> PHOTO_SMALL_SIZE
            );
        }
        $this->Assign('communitys', $this->shape_community($list));
    }

    /**
     * 情報の成形
     *
     * @access private
     * @return array
     */
    function shape_community($community)
    {
        $list = array();
        $row = 0;
        $column = 0;
        foreach ($community as $value){
            // 改行処理
            if ($column >= 5){
                $column = 0;
                $row++;
            }
            $list[$row][$column] = $value;
            $column++;
        } // foreach ($result as $value)
        
        return $list;
    }
} // webapp
?>
