<?php
/* ========================================================================
 - [modules/friend/forum/list.php]
 -      トピック一覧
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/08/28] 基礎情報を親クラスから引っ張るように修正
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_pager.php';
require_once WEBAPP_LIB_DIR.'wap_friend.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_friend
{
    /**
     * コメント削除ID
     * @var integer
     */
    var $delete = 0;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));

        $this->setTemplateFile('friend/forum/list.tpl');
        $this->addJavas('common.js');

        $this->setSafety('delete');

        $this->set_forum();
        $this->set_topic();

        $icons = array(
            STATUS_TOPIC_BULLETIN=> 'bulletin.gif',
            STATUS_TOPIC_EVENT=> 'event.gif',
        );
        $this->Assign('icons', $icons);
    }

    /**
     * フォーラム情報の取得
     *
     * @access private
     * @param integer $ref_topic
     * @return void
     */
    function set_forum()
    {
        $sql=
            'SELECT '.
                'sum(post) as total,'.
                'count(id) as ct '.
            'FROM '.
                DB_PREFIX.'frm_topic '.
            'WHERE '.
                'ref_account = '.$this->ref_friend;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        $this->Assign('forum', $result);
    }

    /**
     * トピック一覧の設定
     *
     * @access private
     * @return void
     */
    function set_topic()
    {
        $offset = RKT_validate::getSafety('number', 'offset');
        $_SESSION['offset'] = $offset;
        
        /* 友達か？ */
        $where = '';
        if ($this->isFriend()){
            $where = 'OR visibility = '.VISIBILITY_FRIEND.' ';
        }

        $objpgr = new RKT_pager($this->objdb, $offset, LIMIT_FORUM);    // クラスの生成
        $sql=
            'SELECT '.
                'id,'.
                'post,'.
                'topic,'.
                'comment '.
            'FROM '.
                DB_PREFIX.'frm_topic '.
            'WHERE '.
                'ref_account = '.$this->ref_friend.' AND '.
                '(visibility = '.VISIBILITY_PROTECTED.' '.
                $where.') '.
            'ORDER BY '.
                'modify DESC';
        $objpgr->setSql($sql);

        $page = array(
            'infos'=> $objpgr->getInfo(),
            'links'=> $objpgr->getPager()
        );
        $this->Assign('page', $page);

        $result = $objpgr->getValues();
        $list = array();
        foreach ($result as $value){
            $list[] = array(
                'id'=> $value['id'],
                'post'=> $value['post'],
                'topic'=> $value['topic'],
                'comment'=> $value['comment'],
                'pictures'=> $this->get_picture($value['id']),
            );
        }

        $this->Assign('list', $list);
    }

    /**
     * 添付画像の取得
     *
     * @access private
     * @param integer $ref_topic
     * @return array
     */
    function get_picture($ref_topic)
    {
        $sql=
            'SELECT '.
                'id,'.
                'thumbnail as src,'.
                't_width as width,'.
                't_height as height '.
            'FROM '.
                DB_PREFIX.'frm_picture '.
            'WHERE '.
                'ref_account = '.$this->ref_friend.' AND '.
                'status = '.STATUS_PICTURE_TOPIC.' AND '.
                'ref_relation = '.$ref_topic;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        return $result;
    }
} // webapp
?>
