<?php
/* ========================================================================
 - [modules/friend/edit/favorite.php]
 -      お気に入り追加
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_manip.php';
require_once WEBAPP_LIB_DIR.'wap_friend.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_friend
{
    /**
     * お気に入りID
     * @var integer
     */
    var $id = null;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));

        $this->setTemplateFile('friend/edit/favorite.tpl');

        /* URL引数の取得 */
        $this->setSafety('id');
        $this->Assign('id', $this->id);

        /* 削除 */
        if ($this->delete_favorite()){
            header('Location: '.HTTP_ACTION.'private/show/favorite/');
            exit();
        }        

        /* アクション処理 */
        if (!empty($_REQUEST['again'])){
            header('Location: '.HTTP_ACTION.'friend/show/profile/'.$this->ref_friend.'/again/');
            exit();
        }

        // データ操作クラスの生成
        $this->objmnp = new RKT_manip($this->objdb,  DB_PREFIX.'fri_favorite');
        $result = $this->do_query();
        if ($result == RKT_MANIP_COMPLETE){
            header('Location: '.HTTP_ACTION.'private/show/favorite/');
            exit();
        }
    }

    /**
     * カレントIDの取得
     *
     * @access private
     * @return integer
     */
    function get_curid()
    {
        $sql=
            'SELECT '.
                'id '.
            'FROM '.
                DB_PREFIX.'fri_favorite '.
            'WHERE '.
                'ref_account = '.$this->account['id'].' AND '.
                'ref_friend = '.$this->ref_friend;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        return $result['id'];
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return integer  データ操作結果
     */
    function do_query()
    {
        $curid = $this->get_curid();
        // 新規登録以外の処理
        if (!empty($curid)){
            $this->objmnp->setCurID($curid);
        } else {
            $this->objmnp->setValue('ref_account',$this->account['id']);
            $this->objmnp->setValue('ref_friend', $this->ref_friend);
        }

        // 直接入力
        $this->objmnp->setValue('modify', date('Y-m-d H:i:s'));

        return $this->objmnp->doManip($this);
    }

    /**
     * お気に入りの削除
     *
     * @access private
     * @return integer  データ操作結果
     */
    function delete_favorite()
    {
        if (empty($_GET['delete'])){
            return false;
        }

        $sql =
            'DELETE FROM '.
                DB_PREFIX.'fri_favorite '.
            'WHERE '.
                'ref_account ='.$this->account['id'].' AND '.
                'ref_friend = '.$this->ref_friend;
        return $this->objdb->exec($sql);
    }
} // webapp
?>
