<?php
/* ========================================================================
 - [modules/community/edit/exit.php]
 -      コミュニティの退会
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/08/27] 基礎情報を親クラスから引っ張るように修正
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once WEBAPP_LIB_DIR.'wap_community.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_community
{
    /**
     * 会員ステータス
     * @var integer
     */
    var $status = null;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));

        $this->setTemplateFile('community/edit/exit.tpl');
                
        $this->set_member();
        
        $this->Assign('complete', $this->do_query());
    }

    /**
     * メンバー情報の設定
     *
     * @access private
     * @return void
     */
    function set_member()
    {
        $sql=
            'SELECT '.
                'status '.
            'FROM '.
                DB_PREFIX.'com_names '.
            'WHERE '.
                'ref_community = '.$this->ref_community.' AND '.
                'ref_account = '.$this->account['id'] .' AND '.
                '(status = '.STATUS_COMMUNITY_ADMIN.' OR '.
                 'status = '.STATUS_COMMUNITY_MEMBER.' OR '.
                 'status = '.STATUS_COMMUNITY_CHANGE.')';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        $this->status = empty($result['status'])?0:$result['status'];

        $this->Assign('status', $this->status);
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return boolean
     */
    function do_query()
    {
        if (empty($_POST['manip'])){
            return false;
        }
        
        
        $this->delete_names();
        $this->update_total();
        
        return true;
    }

    /**
     * 名簿の削除
     *
     * @access private
     * @return integer
     */
    function delete_names()
    {
        $sql=
            'SELECT '.
                'id '.
            'FROM '.
                DB_PREFIX.'com_names '.
            'WHERE '.
                'status != '.STATUS_COMMUNITY_ADMIN.' AND '.
                'ref_community = '.$this->ref_community.' AND '.
                'ref_account = '.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        if (empty($result['id'])){
            return false;
        }

        $sql =
            'DELETE FROM '.
                DB_PREFIX.'com_names '.
            'WHERE '.
                'id = '.$result['id'];
        $this->objdb->exec($sql);
        
        return $result;
    }

    /**
     * 会員総数を更新
     *
     * @access private
     * @return void
     */
    function update_total()
    {
        $sql = 
            'SELECT '.
                'count(id) as total '.
            'FROM '.
                DB_PREFIX.'com_names '.
            'WHERE '.
                'ref_community = '.$this->ref_community.' AND '.
                '(status = '.STATUS_COMMUNITY_MEMBER.' OR '.
                 'status = '.STATUS_COMMUNITY_CHANGE.' OR '.
                 'status = '.STATUS_COMMUNITY_ADMIN.')';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        $total = empty($result['total'])?0:$result['total'];

        $sql =
            'UPDATE '.
                DB_PREFIX.'com_community '.
            'SET '.
                'total = '.$total.' '.
            'WHERE '.
                'id = '.$this->ref_community;
        $this->objdb->exec($sql);
    }
} // webapp
?>
