<?php
/* ========================================================================
 - [modules/admin/item/item.php]
 -      コンテンツ記事編集
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/09/22] 画像が相対パスになる件を修正(relative_urls : false)
 -      [2006/08/29] ファイルパスの定数名を変更
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_manip.php';
require_once WEBAPP_LIB_DIR.'wap_admin.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_admin
{
    /**
     * コンテンツID
     * @var integer
     */
    var $id = null;

    /**
     * カテゴリID
     * @var integer
     */
    var $ref_category = null;

    /**
     * データ操作オブジェクト
     * @var object
     */
    var $objmnp = null;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN));

        $this->setTemplateFile('admin/item/item.tpl');        
        $this->addJavas('tiny_mce/tiny_mce.js');

        // URL引数の取得
        $this->setSafety('id');
        $this->Assign('id', $this->id);
        $this->setSafety('ref_category');
        $this->set_ref_category();
        $this->Assign('ref_category', $this->ref_category);

        // データ操作クラスの生成
        $this->objmnp = new RKT_manip($this->objdb, DB_PREFIX.'itm_item');
        $result = $this->do_query();
        if ($result == RKT_MANIP_COMPLETE){
            header('Location: '.HTTP_ACTION.'admin/item/list/complete/'.WAP_URI_SEPARATOR.'ref_category='.$this->ref_category);
            exit();
        }
        if ($this->delete_item()){
            header('Location: '.HTTP_ACTION.'admin/item/list/complete/'.WAP_URI_SEPARATOR.'ref_category='.$this->ref_category);
            exit();
        }
        
        $this->set_date();
        $this->set_tinymce();
        $this->set_category();
        $this->set_origin();
    }

    /**
     * 日付の設定
     *
     * @return void
     **/
    function set_date()
    {
        $timestamp  = time();

    	$years = array();
    	$months = array();
    	$days = array();

    	$num = WAP_START_YEAR;
    	$max_year = $num + 3;
    	for ($num;$num<$max_year;$num++) {
    		$years[$num] = $num;
    	}
    	for ($num=1;$num<=12;$num++) {
            $num = sprintf('%02d',$num);
    		$months[$num] = $num;
    	}
    	for ($num=1;$num<=31;$num++) {
            $num = sprintf('%02d',$num);
    		$days[$num] = $num;
    	}
    	for ($num=0;$num<=23;$num++) {
            $num = sprintf('%02d',$num);
    		$hours[$num] = $num;
    	}

        $this->Assign('years', $years);
        $this->Assign('months', $months);
        $this->Assign('days', $days);
        
        $now_date = date('Y-m-d H:i:s',$timestamp);

        /* 開始年月日: */
        $date = $this->objmnp->getValue('open_date');
        $date = empty($date)?$this->objmnp->getInitValue('open_date'):$date;
        $date = empty($date)?$now_date:$date;

        $init_date = RKT_calendar::splitDate($date);
        $this->Assign('open_date', $init_date);

        /* 表示期限: */
        $date = $this->objmnp->getValue('close_date');
        $date = empty($date)?$this->objmnp->getInitValue('close_date'):$date;

        $init_date = RKT_calendar::splitDate($date);
        $this->Assign('close_date', $init_date);


        /* 終了年月日: */
        $date = $this->objmnp->getValue('deadline');
        $date = empty($date)?$this->objmnp->getInitValue('deadline'):$date;

        $init_date = RKT_calendar::splitDate($date);
        $this->Assign('deadline', $init_date);
    }

    /**
     * カテゴリIDの設定
     *
     * @access private
     * @return void
     */
    function set_ref_category()
    {
        if (!empty($this->ref_category)){
            return ;
        }
        $sql=
            'SELECT '.
                'ref_category '.
            'FROM '.
                DB_PREFIX.'itm_item '.
            'WHERE '.
                'id='.$this->id;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        
        $this->ref_category = $result['ref_category'];
    }

    /**
     * 親カテゴリの設定
     *
     * @access private
     * @return void
     */
    function set_tinymce()
    {
        $content_css = BASE_URL.'resource/css/private.css';
        $link_list_url = HTTP_ACTION.'admin/item/link_list/'.WAP_URI_SEPARATOR.'ref_category='.$this->ref_category;
        $image_list_url = HTTP_ACTION.'admin/item/image_list/'.WAP_URI_SEPARATOR.'ref_category='.$this->ref_category;
        $init = 
            'tinyMCE.init({'.
                'mode : "textareas",'.
                'theme : "advanced",'.
                'plugins : "table,save,advimage,advlink,emotions,preview,contextmenu,paste,directionality,fullscreen,noneditable",'.
                'theme_advanced_buttons1_add : "fontselect,fontsizeselect",'.
                'theme_advanced_buttons2_add_before: "save,newdocument,separator,cut,copy,paste,separator",'.
                'theme_advanced_buttons2_add : "preview,separator,forecolor,backcolor",'.
                'theme_advanced_buttons3_add_before : "tablecontrols,separator",'.
                'theme_advanced_buttons3_add : "emotions,separator,fullscreen",'.
                'theme_advanced_toolbar_location : "top",'.
                'theme_advanced_toolbar_align : "left",'.
                'theme_advanced_path_location : "bottom",'.
                'content_css : "'.$content_css.'",'.
                'external_link_list_url : "'.$link_list_url.'",'.
                'external_image_list_url : "'.$image_list_url.'",'.
                'file_browser_callback : "fileBrowserCallBack",'.
                'language : "ja_utf-8",'.
                'theme_advanced_resize_horizontal : false,'.
                'theme_advanced_resizing : true,'.
                'relative_urls : false,'.
                'width : "640"'.
            '});';
        $this->baseAssign('javascript', $init);
    }

    /**
     * 親カテゴリの設定
     *
     * @access private
     * @return void
     */
    function set_category()
    {
        $sql=
            'SELECT '.
                'category '.
            'FROM '.
                DB_PREFIX.'itm_category '.
            'WHERE '.
                'id='.$this->ref_category;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        
        $this->Assign('category',$result['category']);
    }

    /**
     * 親カテゴリの設定
     *
     * @access private
     * @return void
     */
    function set_origin()
    {
        $sql=
            'SELECT '.
                'count(*) as ct '.
            'FROM '.
                DB_PREFIX.'itm_item '.
            'WHERE '.
                'ref_category='.$this->ref_category;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);

        $origin = date('ymd').'_'.$this->ref_category.'_'.($result['ct'] + 1);
        $this->Assign('origin',$origin);
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return integer  データ操作結果
     */
    function do_query()
    {
        // 新規登録以外の処理
        if (!empty($this->id)){
            $this->objmnp->setCurID($this->id);
        } else {
            $this->objmnp->setValue('avail', AVAIL_DISABLE);
        }

        /* 直接入力 */        
        $this->objmnp->setValue('modify', date('Y-m-d H:i:s'));
        $this->objmnp->setValue('ref_category', $this->ref_category);

        // 更新しない項目名
        $skip = array(
            'avail',
            'body'
        );
        if ($this->ref_category != ITEM_CATEGORY_QUESTION){
            $skip[] = 'deadline';
        }
        $this->objmnp->catchInput($skip);


        /* 以下のタグを許可 */
        $tags  = ALLOWABLE_TAGS;
        $tags .= '<div><p><sub><sup><blockquote><hr>';
        $tags .= '<h1><h2><h3><h4><h5><h6>';
        $tags .= '<table><thead><tbody><tr><th><td>';
        $validate_info = array(
            'type'=> 'string',
            'required'=> true,
            'tags'=> $tags
        );
        $this->objmnp->setInput('body', $validate_info);

        return $this->objmnp->doManip($this);
    }

    /**
     * ファイルの削除
     *
     * @access private
     * @return integer  データ操作結果
     */
    function delete_file($id)
    {
        $sql=
            'SELECT '.
                'mimetype,'.
                'filename,'.
                'thumbnail '.
            'FROM '.
                DB_PREFIX.'itm_fileinfo '.
            'WHERE '.
                'id = '.$id;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);

        if (empty($result)){
            return 0;
        }

        $this->objfile->unlink(ARCHIVES_DIR.$result['filename']);
        if (preg_match('/image/i', $result['mimetype'])){
            $this->objfile->unlink(ARCHIVES_DIR.$result['thumbnail']);
        }

        $sql =
            'DELETE FROM '.
                DB_PREFIX.'itm_fileinfo '.
            'WHERE '.
                'id ='.$id;
        return $this->objdb->exec($sql);
    }

    /**
     * アンケート項目の削除
     *
     * @access private
     * @return integer  データ操作結果
     */
    function delete_item()
    {
        if (empty($_POST['delete'])){
            return false;
        }

        $sql =
            'DELETE FROM '.
                DB_PREFIX.'itm_select '.
            'WHERE '.
                'ref_item ='.$this->id;
        $this->objdb->exec($sql);

        $sql =
            'DELETE FROM '.
                DB_PREFIX.'itm_option '.
            'WHERE '.
                'ref_item ='.$this->id;
        $this->objdb->exec($sql);

        $sql =
            'DELETE FROM '.
                DB_PREFIX.'itm_item '.
            'WHERE '.
                'id ='.$this->id;
        return $this->objdb->exec($sql);
    }
} // webapp
?>
