<?php
/* ========================================================================
 - [modules/admin/item/image_list.php]
 -      TinyMCE用画像リスト
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/08/03] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_pager.php';
require_once WEBAPP_LIB_DIR.'wap_admin.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_admin
{
    /**
     * カテゴリID
     * @var integer
     */
    var $ref_category = null;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        $this->setTemplateFile('admin/item/list.tpl');

        // URL引数の取得
        $this->setSafety('ref_category');

        header('Content-Type: text/html; charset=Shift_JIS');
        $this->set_list();
    }

    /**
     * カバーリストの設定
     *
     * @access private
     * @return void
     **/
    function set_list()
    {
        $sql=
            'SELECT '.
                'subject,'.
                'filename '.
            'FROM '.
                DB_PREFIX.'itm_fileinfo '.
            'WHERE '.
                'ref_category = '.$this->ref_category.' AND '.
                'width != 0 '.
            'LIMIT 10';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        
        $list = array();
        foreach ($result as $value){
        	$subject = mb_convert_encoding($value['subject'], 'SJIS', ENCODE_TYPE);
            $list[] = '["'.$subject.'", "'.BASE_URL.$value['filename'].'"]';
        }

        echo
            'var tinyMCEImageList = new Array('."\r\n".
            implode(',',$list)."\r\n".
            ');';
        exit();
    }
} // webapp
?>
