<?php
/* ========================================================================
 - [modules/admin/design/upload.php]
 -      テーマ素材アップロード
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/08/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_upload.php';
require_once WEBAPP_LIB_DIR.'wap_admin.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_admin
{
    /**
     * テーマID
     * @var integer
     */
    var $id = null;

    /**
     * 削除ファイル名
     * @var string
     */
    var $delete = '';

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN));

        $this->setTemplateFile('admin/design/upload.tpl');        

        // URL引数の取得
        $this->setSafety('id');
        $this->Assign('id', $this->id);
        $this->setSafety('delete', '_REQUEST', 'string');
        
        if ($this->upload()){
            $this->Assign('complete', true);
        }

        if ($this->delete_file()){
            $this->Assign('complete', true);
        }
        $this->set_list();
    }

    /**
     * ファイルリストの設定
     *
     * @access private
     * @return void
     **/
    function set_list()
    {
        if (!is_dir(THEME_DIR.$this->id.DIRECTORY_SEPARATOR)){
            return false;
        }

        $dir = THEME_DIR.$this->id.DIRECTORY_SEPARATOR;
        $files = glob($dir.'{*.jpg,*.jpeg,*.gif,*.png}', GLOB_BRACE);

        $list = array();
        foreach ($files as $file){
            $infos = @stat($file);
            
            $list[] = array(
                'name'=>  basename($file),
                'mode'=>  substr(decoct($infos[2]),-4),
                'uid'=>   $infos[4],
                'gid'=>   $infos[5],
                'size'=>  number_format($infos[7]/1000),
                'mtime'=> date('Y/m/d H:i:s',$infos[9]),
            );
        }
        $this->Assign('list', $list);
    }

    /**
     * 画像のアップロード処理
     *
     * @access public
     * @return integer  データ操作結果
     */
    function upload()
    {
        /* 一覧用画像 */
        if (empty($_FILES['file'])){
            return false;
        }
        /* ファイルの種類が画像か判定 */
        if (!preg_match('/image/i', $_FILES['file']['type'])){
            return false;
        }

        // ファイルの保存
        $dir = THEME_DIR.$this->id.DIRECTORY_SEPARATOR;
        $filename = $dir.$_FILES['file']['name'];
        $tmp_name = $_FILES['file']['tmp_name'];

        if (!move_uploaded_file($tmp_name, $filename)){
            if (!copy($tmp_name, $filename)){
                if (!unlink($filename)){
                    error_log('admin/design/upload.php::upload()'."\r\n", 3, ERROR_LOG_FILE);
                }
                return false;
            } // if (!copy($tmp_name, $filename))
        } // if (!move_uploaded_file($tmp_name, $filename))
        
        return true;
    }

    /**
     * ファイルの削除
     *
     * @access private
     * @return void
     **/
    function delete_file()
    {
        if (empty($this->delete)){
            return false;
        }
        $dir = THEME_DIR.$this->id.DIRECTORY_SEPARATOR;
        @unlink($dir.$this->delete);
        
        return true;
    }
} // webapp
?>
