<?php
/* ========================================================================
 - [modules/admin/account/sendmail.php]
 -      配信メール送信
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/09/26] メール送信機構を変更
 -      [2006/08/06] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_manip.php';
require_once LIB_DIR.'rkt_pager.php';
require_once WEBAPP_LIB_DIR.'sendmail.php';
require_once WEBAPP_LIB_DIR.'wap_admin.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_admin
{
    /**
     * メール送信ID
     * @var integer
     */
    var $id = null;

    /**
     * メール送信アクション
     * @var string
     */
    var $action = 'mails/complete/';

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN));
        
        $this->setTemplateFile('admin/account/sendmail.tpl');        

        $this->setSafety('id');
        $this->Assign('id', $this->id);

        // データ操作クラスの生成
        $this->objmnp = new RKT_manip($this->objdb, DB_PREFIX.'sys_mail');
        $result = $this->do_query();
        if ($result == RKT_MANIP_COMPLETE){
            $this->id = $this->objmnp->getCurID();
            header('Location: '.SSL_ACTION.'admin/account/'.$this->action.WAP_URI_SEPARATOR.'id='.$this->id);
            exit();
        }
        $this->set_sendmail();
        $this->set_froms();
        $status = array(
            STATAS_MAIL_ROUGH=> STATAS_MAIL_LABEL_ROUGH,
            STATAS_MAIL_SEND=>  STATAS_MAIL_LABEL_SEND,
            STATAS_MAIL_SENT=>  STATAS_MAIL_LABEL_SENT,
        );
        $this->Assign('status',$status);
        
        $this->set_condition();
    }

    /**
     * メール送信の設定
     *
     * @access private
     * @return void
     */
    function set_sendmail()
    {
        if (empty($this->id)){
            return ;
        }
        if (preg_match('/action/i',$_SERVER['REQUEST_URI'])){
            $_SESSION['sendmail'] = true;
            header('Location: '.SSL_ACTION.'admin/account/sendmail/complete/'.WAP_URI_SEPARATOR.'id='.$this->id);
            exit();
        }

        if (empty($_SESSION['sendmail'])){
            return ;
        }
        unset($_SESSION['sendmail']);
        
        $func = array('webapp','sendMail');
        $this->Assign('func', $func);
        $this->Assign('sendmail', true);
    }

    /**
     * 送信元メールアドレス
     *
     * @access private
     * @return void
     */
    function set_froms()
    {
        $this->Assign('froms', WAP_ADMINISTRATOR);
    }

    /**
     * 条件の設定
     *
     * @access private
     * @return void
     */
    function set_condition()
    {
        if (!empty($this->id)){
            return ;
        }
        $sql=
            'SELECT '.
                'condition '.
            'FROM '.
                DB_PREFIX.'sys_mail '.
            'WHERE '.
                'id='.$this->id;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        if (empty($result)){
            return ;
        }
        
        $_SESSION['condition'] = $result['condition'];
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return integer  データ操作結果
     */
    function do_query()
    {
        $status  = STATAS_MAIL_ROUGH;
        $trigger = 'rough';
        if (empty($_POST['rough'])){
            $trigger = 'manip';
            $status  = STATAS_MAIL_SENT;
            $this->action = 'sendmail/action/';
        }

        // 新規登録以外の処理
        if (!empty($this->id)){
            $this->objmnp->setCurID($this->id);
        } else {
            $this->objmnp->setValue('regist_date', date('Y-m-d H:i:s'));

            $conditions = $this->catchCondition(array());
            $this->objmnp->setValue('condition', serialize($conditions));
        }

        // 直接入力
        $this->objmnp->setValue('modify', date('Y-m-d H:i:s'));
        $this->objmnp->setValue('status', $status);


        // 更新しない項目名
        $skip = array(
            'regist_date',
        );
        $this->objmnp->catchInput($skip);

        return $this->objmnp->doManip($this,$trigger);
    }

    /**
     * メール送信
     *
     * @access public
     * @return void
     */
    function sendMail($ref_mail)
    {
        include_once WEBAPP_LIB_DIR.'admin/sys_mail.php';

        $objsysmail = new sys_mail($ref_mail);
        $objsysmail->execute();
    }
} // webapp
?>
