<?php
/* ========================================================================
 - [modules/public/registry/sendmail.php]
 -      会員登録確認メール発送
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2007/01/21] テーブルを fri_friends から fri_invite に変更
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_manip.php';
require_once LIB_DIR.'rkt_calendar.php';
require_once WEBAPP_LIB_DIR.'sendmail.php';
require_once WEBAPP_LIB_DIR.'sql_query.php';
require_once WEBAPP_LIB_DIR.'wap_public.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_public
{
    /**
     * 友達名簿ID
     * @var integer
     */
    var $ref_invite = 0;

    /**
     * 暗号化用の種
     * @var string
     */
    var $seed = '';

    /**
     * 暗号化文字列
     * @var string
     */
    var $key = '';

    /**
     * データ操作オブジェクト
     * @var object
     */
    var $objmnp = null;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        $this->setTemplateFile('public/registry/sendmail.tpl');

        /* PathInfo引数の設定 */
        $this->setPathInfo('ref_invite');
        $this->Assign('ref_invite', $this->ref_invite);
        $this->setPathInfo('seed',1,'string');
        $this->Assign('seed', $this->seed);
        $this->setPathInfo('key',2,'string');
        $this->Assign('key', $this->key);


        // データ操作クラスの生成
        $this->objmnp = new RKT_manip($this->objdb, DB_PREFIX.'act_account');
        $result = $this->do_query();
        if ($result == RKT_MANIP_COMPLETE){
            $this->insert_profile();
            $this->update_invite();
            $this->send_mail();
            /* 入力セッションの破棄 */
            unset($_SESSION[DB_PREFIX.'act_account']);

            $this->request_sns();
            $this->request_entry();
        } else {
            $this->error = true;
        }
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return integer  データ操作結果
     */
    function do_query()
    {
        $this->objmnp->setRequestType("_SESSION['".DB_PREFIX.'act_account'."']");

        /* 直接入力 */
        $this->objmnp->setValue('modify', date('Y-m-d H:i:s'));
        $this->objmnp->setValue('avail', AVAIL_PENDING);
        $this->objmnp->setValue('status', WAP_ACC_MEMBER);
        $this->objmnp->setValue('regist_date', date('Y-m-d H:i:s'));
        $this->objmnp->setValue('last_login', date('0000-00-00 00:00:00'));
        $this->objmnp->setValue('friend_number', 1);

        /* 入力データの加工設定 */
        $func = array('RKT_auth', 'passwdHash');
        $this->objmnp->setInputEffect('password', array('func'=>$func));
        $func = array('sql_query', 'hash');
        $this->objmnp->setInputEffect('email_hash', array('func'=>$func, 'key'=>'email'));
        $func = array('sql_query', 'encrypt');
        $this->objmnp->setInputEffect('email', array('func'=>$func));

        // 更新しない項目名
        $skip = array(
            'ref_blog',
            'cellular',
        );
        $this->objmnp->catchInput($skip);

        $_SESSION[DB_PREFIX.'act_account']['manip'] = true;

        return $this->objmnp->doManip($this);
    }

    /**
     * プロフィールの挿入
     *
     * @access private
     * @return boolean  真偽値
     */
    function insert_profile()
    {
        $first_name  = $_SESSION[DB_PREFIX.'act_account']['first_name'];
        $second_name = $_SESSION[DB_PREFIX.'act_account']['second_name'];
        $nickname    = $_SESSION[DB_PREFIX.'act_account']['nickname'];

        $first_name  = sql_query::encrypt($first_name);
        $second_name = sql_query::encrypt($second_name);

        $values = array(
            'ref_account'=> $this->objmnp->getCurID(),
            'modify'=> $this->objdb->quote(date('Y-m-d H:i:s')),
            'first_name'=> $this->objdb->quote($first_name),
            'second_name'=> $this->objdb->quote($second_name),
            'name_flag'=> VISIBILITY_HIDDEN,
            'nickname'=> $this->objdb->quote($nickname),
            'visibility'=> VISIBILITY_PUBLIC,                   // ネット上に公開 2007/01/03変更
            'ref_prefecture'=> '48',                            // その他
            'local'=> 'NULL',
            'prefecture_flag'=> VISIBILITY_HIDDEN,
            'ref_sex'=> '3',                                    // 未記入
            'sex_flag'=> VISIBILITY_HIDDEN,
            'ref_blood'=> '5',                                  // 不明
            'blood_flag'=> VISIBILITY_HIDDEN,
            'birthday'=> $this->objdb->quote(date('Y-m-d H:i:s')),
            'birthday_flag'=> VISIBILITY_HIDDEN,
            'age_flag'=> VISIBILITY_HIDDEN,
            'ref_married'=> '1',                                // 無回答
            'married_flag'=> VISIBILITY_HIDDEN,
            'ref_hometown'=> 'NULL',
            'homelocal'=> 'NULL',
            'hometown_flag'=> VISIBILITY_HIDDEN,
            'publicity'=> 'NULL',
        );

        $keys = array_keys($values);
        $column = implode(',',$keys);
        $value = implode(',',$values);

        $sql =
            'INSERT INTO '.
                DB_PREFIX.'act_profile('.$column.')'.
                ' VALUES ('.$value.')';
        return $this->objdb->exec($sql);
    }

    /**
     * 友達名簿の更新
     *
     * @access private
     * @return integer  データ操作結果
     */
    function update_invite()
    {
        $ref_account = $this->objmnp->getCurID();
        $sql =
            'UPDATE '.
                DB_PREFIX.'fri_invite '.
            'SET '.
                'ref_friend='.$ref_account.' '.
            'WHERE '.
                'id='.$this->ref_invite;
        $this->objdb->exec($sql);
    }

    /**
     * メール送信実行
     *
     * @access private
     * @return integer  送信結果
     */
    function send_mail()
    {
        $sql=
            'SELECT '.
                'ref_account,'.
                'ref_friend '.
            'FROM '.
                DB_PREFIX.'fri_invite '.
            'WHERE '.
                'id = '.$this->ref_invite;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
    	$seed = md5($result['ref_account'].RKT_SEED);
        $seed = substr($seed,4,6);
    	$key = md5($seed.$result['ref_friend'].RKT_SEED);
        
        $url = HTTP_ACTION.'public/registry/registry/'.$this->ref_invite.'/'.$seed.'/'.$key.'/';
    	$id  = $this->objmnp->getCurID();

        $objmail = new sendmail('registry');
        $objmail->Assign('url', $url);

        $res = $objmail->send($_SESSION[DB_PREFIX.'act_account']['email']);
    }
} // webapp
?>
